/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.dsv2.module;

import com.alibaba.cola.dto.Response;
import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.api.plugin.Reader;
import com.aliyun.migration.teleport.common.element.meta.Datasource;
import com.aliyun.migration.workflow.migration.common.AbstractReader;
import com.aliyun.migration.workflow.migration.dsv1.handle.AbstractDolphinv1Handler;
import com.aliyun.migration.workflow.migration.dsv2.handle.Dolphinv2FileHandler;
import com.aliyun.migration.workflow.migration.dsv2.handle.Dolphinv2OpenApiHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dolphinv2Reader
extends AbstractReader {
    private static final Logger log = LoggerFactory.getLogger(Dolphinv2Reader.class);
    private AbstractDolphinv1Handler dolphinv2Handler;

    public Reader init(TaskContext taskContext) {
        this.setTaskContext(taskContext);
        this.optimalizeReader();
        Datasource scheduleDataSource = taskContext.getReaderDatasource();
        this.supplyDataSourceOperatorType(scheduleDataSource);
        this.dolphinv2Handler = scheduleDataSource.getOperaterType() == Datasource.OperaterType.AUTO ? new Dolphinv2OpenApiHandler(scheduleDataSource, taskContext) : new Dolphinv2FileHandler(scheduleDataSource, taskContext);
        this.dolphinv2Handler.init();
        return this;
    }

    public Response preCheck(Datasource scheduleDataSource) {
        return this.dolphinv2Handler.preCheck(scheduleDataSource);
    }

    public WorkflowProjectPackage read() throws Exception {
        WorkflowProjectPackage workflowProjectPackage = this.dolphinv2Handler.read();
        this.taskContext.setWorkflowProjectPackage(workflowProjectPackage);
        return workflowProjectPackage;
    }

    public void close() {
    }
}

