/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.dsv2.handle;

import com.alibaba.cola.dto.Response;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.DolphinSchedulerApi;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.DolphinSchedulerRequest;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v2.DolphinSchedulerApiV2Service;
import com.aliyun.dataworks.migrationx.reader.dolphinscheduler.DolphinSchedulerReader;
import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.teleport.common.element.meta.Datasource;
import com.aliyun.migration.workflow.migration.dsv2.handle.Dolphinv2FileHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dolphinv2OpenApiHandler
extends Dolphinv2FileHandler {
    private static final Logger log = LoggerFactory.getLogger(Dolphinv2OpenApiHandler.class);
    private DolphinSchedulerReader dolphinSchedulerReader;
    private DolphinSchedulerApi dolphinSchedulerApiService;

    public Dolphinv2OpenApiHandler(Datasource scheduleDataSource, TaskContext taskContext) {
        super(scheduleDataSource, taskContext);
    }

    @Override
    public void init() {
        Object exportFilePath;
        String project;
        Map properties = this.scheduleDataSource.getProperties();
        String endpoint = (String)properties.get("endpoint");
        String token = (String)properties.get("token");
        this.project = project = (String)properties.get("project");
        List<String> projects = Collections.singletonList(project);
        String version = (String)properties.get("version");
        if (!NumberUtils.isDigits((String)version)) {
            version = "2.0.1";
        }
        if (StringUtils.isBlank((CharSequence)(exportFilePath = (String)properties.get("source-file-path")))) {
            exportFilePath = "temp/dolphinv2/" + this.scheduleDataSource.getName();
            properties.put("source-file-path", exportFilePath);
        }
        this.dolphinSchedulerApiService = new DolphinSchedulerApiV2Service(endpoint, token);
        this.dolphinSchedulerReader = new DolphinSchedulerReader(endpoint, token, version, projects, new ArrayList(), new File((String)exportFilePath));
        log.info("init.dolphinv2.reader.success");
    }

    public Response preCheck(Datasource scheduleDataSource) {
        try {
            com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v1.Response listResponse = this.dolphinSchedulerApiService.queryAllProjectList(new DolphinSchedulerRequest());
            if (listResponse.getData() == null || ((List)listResponse.getData()).size() <= 0) {
                return Response.buildFailure((String)BwmServiceErrorCode.PRE_CHECK_ERROR.getCode(), (String)"not.find.the.projects");
            }
        }
        catch (Exception e) {
            log.error("detect.dolphinschedulev2.error", (Throwable)e);
            return Response.buildFailure((String)BwmServiceErrorCode.PRE_CHECK_ERROR.getCode(), (String)"detect.dolphinschedulev2.error");
        }
        return Response.buildSuccess();
    }

    @Override
    public WorkflowProjectPackage read() {
        File export = this.dolphinSchedulerReader.export();
        Map properties = this.scheduleDataSource.getProperties();
        properties.put("source-file-path", export.getPath());
        super.init();
        return super.read();
    }
}

