/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.dw.merge.module;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.aliyun.migration.api.WorkflowProjectPackage;
import com.aliyun.migration.api.constant.PackageDiffConstant;
import com.aliyun.migration.workflow.migration.common.AbstractPlugin;
import com.aliyun.migration.workflow.migration.common.config.BwmSaasConfiguration;
import com.aliyun.migration.workflow.migration.common.file.BwmPackageFileOperator;
import com.aliyun.migration.workflow.migration.common.file.BwmPackageSrDiffFileOperator;
import com.aliyun.migration.workflow.migration.common.file.BwmPackageSrMergeFileOperator;
import com.aliyun.migration.workflow.migration.common.file.BwmPackageSrResultStatisticFileOperator;
import com.aliyun.migration.workflow.migration.common.file.BwmPackageSrSnapshotFileOperator;
import com.aliyun.migration.workflow.migration.common.utils.cloud.OssCloudClient;
import com.aliyun.migration.workflow.migration.dw.merge.common.MergeTaskContext;
import com.aliyun.migration.workflow.migration.dw.merge.diff.PackageDiffCompareTool;
import com.aliyun.migration.workflow.migration.dw.merge.diff.PackageDiffConflictTool;
import com.aliyun.migration.workflow.migration.dw.merge.diff.PackageDiffExecuteTool;
import com.aliyun.migration.workflow.migration.dw.merge.diff.PackageDiffFileOperator;
import com.aliyun.migration.workflow.migration.dw.merge.diff.common.DiffConflictPair;
import com.aliyun.migration.workflow.migration.dw.merge.diff.common.DiffElement;
import com.aliyun.migration.workflow.migration.dw.merge.diff.common.PackageDiffCommonTools;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DwMergeAssistant
extends AbstractPlugin {
    private static final Logger log = LoggerFactory.getLogger(DwMergeAssistant.class);
    private MergeTaskContext taskContext;

    public void init(MergeTaskContext taskContext) {
        this.taskContext = taskContext;
    }

    public void root() {
        this.readFile();
        this.readSetting();
        block0 : switch (this.taskContext.getMergeMode()) {
            case SOURCE_OVERWRITE: {
                log.info("\u7528\u6237\u9009\u62e9\u6e90\u7aef\u8986\u76d6\u6a21\u5f0f\uff0c\u53d6\u6d88Merge\u64cd\u4f5c\uff0c\u76f4\u63a5\u8f93\u51fa\u5305\u5230\u6307\u5b9a\u8def\u5f84");
                this.taskContext.setStage(1);
                this.taskContext.setResultPkg(this.taskContext.getConvertTPkg());
                break;
            }
            case SOURCE_PRIORITY: {
                log.info("\u7528\u6237\u9009\u62e9\u6e90\u7aef\u4f18\u5148\u6a21\u5f0f\uff0c\u81ea\u52a8\u5b8c\u6210Merge\uff0c\u76f4\u63a5\u8f93\u51fa\u5305\u5230\u6307\u5b9a\u8def\u5f84");
                this.generateDiffAndConfict();
                if (this.taskContext.getDiffConflictPairs() != null && !this.taskContext.getDiffConflictPairs().isEmpty()) {
                    this.taskContext.getDiffConflictPairs().forEach(diffConfictPair -> diffConfictPair.setChoseSrc(true));
                }
                this.taskContext.setStage(1);
                this.merge();
                break;
            }
            case TARGET_PRIORITY: {
                log.info("\u7528\u6237\u9009\u62e9\u76ee\u6807\u7aef\u4f18\u5148\u6a21\u5f0f\uff0c\u81ea\u52a8\u5b8c\u6210Merge\uff0c\u76f4\u63a5\u8f93\u51fa\u5305\u5230\u6307\u5b9a\u8def\u5f84");
                this.generateDiffAndConfict();
                if (this.taskContext.getDiffConflictPairs() != null && !this.taskContext.getDiffConflictPairs().isEmpty()) {
                    this.taskContext.getDiffConflictPairs().forEach(diffConfictPair -> diffConfictPair.setChoseSrc(false));
                }
                this.taskContext.setStage(1);
                this.merge();
                break;
            }
            case RULES: {
                log.info("\u7528\u6237\u9009\u62e9\u89c4\u5219\u6a21\u5f0f\uff0c\u81ea\u52a8\u5b8c\u6210Merge\uff0c\u76f4\u63a5\u8f93\u51fa\u5305\u5230\u6307\u5b9a\u8def\u5f84");
                this.generateDiffAndConfict();
                if (this.taskContext.getDiffConflictPairs() != null) {
                    for (DiffConflictPair diffConfictPair2 : this.taskContext.getDiffConflictPairs()) {
                        if (diffConfictPair2.getSrcDiffElement().getDiffType().equals((Object)PackageDiffConstant.DiffType.CONVERT_NODE_PROPERTY_UPDATE)) {
                            if (this.taskContext.getMergeNodePropertyRules().get(PackageDiffConstant.WorkflowNodePropertyType.getWorkflowNodePropertyType((String)diffConfictPair2.getSrcDiffElement().getPropertyPath())).equals((Object)PackageDiffConstant.SourceOrTarget.SOURCE)) {
                                diffConfictPair2.setChoseSrc(true);
                                log.info("\u53d8\u66f4\u8282\u70b9\u5c5e\u6027\u53d8\u66f4\uff0c\u9009\u62e9\u6e90\u7aef\uff0cdiffConfictPair:{}", (Object)JSONObject.from((Object)diffConfictPair2).toJSONString(new JSONWriter.Feature[0]));
                                continue;
                            }
                            diffConfictPair2.setChoseSrc(false);
                            log.info("\u53d8\u66f4\u8282\u70b9\u5c5e\u6027\u53d8\u66f4\uff0c\u9009\u62e9\u76ee\u6807\u7aef\uff0cdiffConfictPair:{}", (Object)JSONObject.from((Object)diffConfictPair2).toJSONString(new JSONWriter.Feature[0]));
                            continue;
                        }
                        if (!diffConfictPair2.getSrcDiffElement().getDiffType().equals((Object)PackageDiffConstant.DiffType.CONVERT_WORKFLOW_PROPERTY_UPDATE)) continue;
                        if (this.taskContext.getMergeWorkflowPropertyRules().get(PackageDiffConstant.WorkflowPropertyType.getWorkflowPropertyType((String)diffConfictPair2.getSrcDiffElement().getPropertyPath())).equals((Object)PackageDiffConstant.SourceOrTarget.SOURCE)) {
                            diffConfictPair2.setChoseSrc(true);
                            log.info("\u53d8\u66f4\u5de5\u4f5c\u6d41\u5c5e\u6027\u53d8\u66f4\uff0c\u9009\u62e9\u6e90\u7aef\uff0cdiffConfictPair:{}", (Object)JSONObject.from((Object)diffConfictPair2).toJSONString(new JSONWriter.Feature[0]));
                            continue;
                        }
                        diffConfictPair2.setChoseSrc(false);
                        log.info("\u53d8\u66f4\u5de5\u4f5c\u6d41\u5c5e\u6027\u53d8\u66f4\uff0c\u9009\u62e9\u76ee\u6807\u7aef\uff0cdiffConfictPair:{}", (Object)JSONObject.from((Object)diffConfictPair2).toJSONString(new JSONWriter.Feature[0]));
                    }
                }
                this.taskContext.setStage(1);
                this.merge();
                break;
            }
            case CUSTOM: {
                switch (this.taskContext.getStage()) {
                    case 0: {
                        log.info("\u7528\u6237\u9009\u62e9\u81ea\u5b9a\u4e49\u6a21\u5f0f\uff0c\u5206\u4e24\u6b65\u624b\u52a8\u5b8c\u6210Merge\u3002\u5f53\u524d\u4e3a\u7b2c\u4e00\u6b65\uff0c\u751f\u6210Merge\u62a5\u8868\u3002\u7528\u6237\u9700\u5728\u62a5\u8868\u4e2d\u5b8c\u6210\u51b2\u7a81\u5904\u7406\uff0c\u7136\u540e\u91cd\u65b0\u8fd0\u884c\u6b64\u547d\u4ee4\u3002");
                        this.generateDiffAndConfict();
                        break block0;
                    }
                    case 1: {
                        log.info("\u7528\u6237\u9009\u62e9\u81ea\u5b9a\u4e49\u6a21\u5f0f\uff0c\u5206\u4e24\u6b65\u624b\u52a8\u5b8c\u6210Merge\u3002\u5f53\u524d\u4e3a\u7b2c\u4e8c\u6b65\uff0c\u6267\u884cMerge\u3002");
                        this.merge();
                    }
                }
            }
        }
    }

    public void exportFile() {
        this.freshPackageBasicInfo(this.taskContext.getResultPkg());
        if (this.taskContext.getBwmSaasConfiguration() == null) {
            this.localExport();
        } else {
            this.saasExport();
        }
    }

    public void localExport() {
        switch (this.taskContext.getStage()) {
            case 0: {
                try {
                    PackageDiffFileOperator.writeDiffConfictXls(this.taskContext.getSrcDiffElementList(), this.taskContext.getCvtDiffElementList(), this.taskContext.getTgtDiffElementList(), this.taskContext.getDiffConflictPairs(), new File(this.taskContext.getResultXlsFilePath()));
                    log.info("DiffConfictXls\u751f\u6210\u6210\u529f:" + this.taskContext.getResultXlsFilePath());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 1: {
                try {
                    BwmPackageFileOperator.writeFile((WorkflowProjectPackage)this.taskContext.getResultPkg(), (File)new File(this.taskContext.getResultPackagePath()));
                    log.info("ResultPkg\u751f\u6210\u6210\u529f:" + this.taskContext.getResultPackagePath());
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void saasExport() {
        switch (this.taskContext.getStage()) {
            case 0: {
                try {
                    PackageDiffFileOperator.writeDiffConfictXls(this.taskContext.getSrcDiffElementList(), this.taskContext.getCvtDiffElementList(), this.taskContext.getTgtDiffElementList(), this.taskContext.getDiffConflictPairs(), new File(this.taskContext.getResultXlsFilePath()));
                    log.info("DiffConfictXls\u751f\u6210\u6210\u529f:" + this.taskContext.getResultXlsFilePath());
                    HashMap<BwmPackageSrDiffFileOperator.PackageStage, JSONArray> diffElementMap = new HashMap<BwmPackageSrDiffFileOperator.PackageStage, JSONArray>();
                    if (!CollectionUtils.isEmpty(this.taskContext.getSrcDiffElementList())) {
                        diffElementMap.put(BwmPackageSrDiffFileOperator.PackageStage.SOURCE, PackageDiffFileOperator.exportDiffWholeTable(this.taskContext.getSrcDiffElementList()));
                    }
                    if (!CollectionUtils.isEmpty(this.taskContext.getCvtDiffElementList())) {
                        diffElementMap.put(BwmPackageSrDiffFileOperator.PackageStage.AFTER_CONVERT, PackageDiffFileOperator.exportDiffWholeTable(this.taskContext.getCvtDiffElementList()));
                    }
                    if (!CollectionUtils.isEmpty(this.taskContext.getTgtDiffElementList())) {
                        diffElementMap.put(BwmPackageSrDiffFileOperator.PackageStage.TARGET, PackageDiffFileOperator.exportDiffWholeTable(this.taskContext.getTgtDiffElementList()));
                    }
                    if (this.taskContext.getConvertTPkg() == null) {
                        BwmPackageSrDiffFileOperator.writeMigrationSrDiffFile((WorkflowProjectPackage)this.taskContext.getReadTPkg(), diffElementMap, (BwmSaasConfiguration)this.taskContext.getBwmSaasConfiguration());
                        break;
                    }
                    BwmPackageSrDiffFileOperator.writeMigrationSrDiffFile((WorkflowProjectPackage)this.taskContext.getConvertTPkg(), diffElementMap, (BwmSaasConfiguration)this.taskContext.getBwmSaasConfiguration());
                    JSONArray conflictElement = PackageDiffFileOperator.exportDiffConfictTable(this.taskContext.getDiffConflictPairs());
                    BwmPackageSrMergeFileOperator.writeMigrationSrConflictFile((JSONArray)conflictElement, (BwmSaasConfiguration)this.taskContext.getBwmSaasConfiguration());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 1: {
                try {
                    BwmPackageFileOperator.writeFile((WorkflowProjectPackage)this.taskContext.getResultPkg(), (File)new File(this.taskContext.getResultPackagePath()));
                    log.info("ResultPkg\u751f\u6210\u6210\u529f:" + this.taskContext.getResultPackagePath());
                    BwmPackageSrSnapshotFileOperator.writeMigrationSrSnapshotFile((WorkflowProjectPackage)this.taskContext.getResultPkg(), (BwmSaasConfiguration)this.taskContext.getBwmSaasConfiguration());
                    BwmPackageSrResultStatisticFileOperator.writeMigrationSrResultMappingOverviewFile((WorkflowProjectPackage)this.taskContext.getConvertTPkg(), (WorkflowProjectPackage)this.taskContext.getResultPkg(), (BwmSaasConfiguration)this.taskContext.getBwmSaasConfiguration());
                    JSONArray conflictElement = PackageDiffFileOperator.exportDiffConfictTable(this.taskContext.getDiffConflictPairs());
                    BwmPackageSrMergeFileOperator.writeMigrationSrConflictFile((JSONArray)conflictElement, (BwmSaasConfiguration)this.taskContext.getBwmSaasConfiguration());
                    log.info("ResultPkg SR JSON\u751f\u6210\u6210\u529f");
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void close() {
        if (this.taskContext.getBwmSaasConfiguration() == null) {
            this.localClose();
        } else {
            this.saasClose();
        }
    }

    public void localClose() {
    }

    public void saasClose() {
        try {
            this.copyLogFile();
            this.uploadFileToOss();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void copyLogFile() {
        BwmSaasConfiguration bwmSaasConfiguration = this.taskContext.getBwmSaasConfiguration();
        String logFilePath = this.taskContext.getConvertTPkg() == null ? bwmSaasConfiguration.getDiscoveryLogFileSavePath(this.taskContext != null && this.taskContext.getReadTPkg() != null && this.taskContext.getReadTPkg().getWorkflowProject() != null ? this.taskContext.getReadTPkg().getWorkflowProject().getProjectId() : null) : bwmSaasConfiguration.getMigrationLogFileSavePath();
        File systemLogFolder = new File("./logs");
        try {
            FileUtils.copyDirectory((File)systemLogFolder, (File)new File(logFilePath));
        }
        catch (IOException e) {
            log.warn("\u62f7\u8d1d\u65e5\u5fd7\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
    }

    public void uploadFileToOss() {
        if (ObjectUtils.isEmpty((Object)this.taskContext.getBwmSaasConfiguration())) {
            log.warn("\u672a\u83b7\u53d6\u5230SaaS\u914d\u7f6e\uff0c\u8df3\u8fc7\u4e0a\u4f20");
            return;
        }
        log.info("\u5f00\u59cb\u4e0a\u4f20\u6587\u4ef6\u5230OSS");
        BwmSaasConfiguration bwmSaasConfiguration = this.taskContext.getBwmSaasConfiguration();
        if (Objects.isNull(bwmSaasConfiguration.getLocal())) {
            log.warn("SaaS\u914d\u7f6e\u4e2dlocal\u914d\u7f6e\u4e3a\u7a7a, \u8df3\u8fc7\u4e0a\u4f20");
            return;
        }
        if (Objects.isNull(bwmSaasConfiguration.getOss())) {
            log.warn("SaaS\u914d\u7f6e\u4e2doss\u914d\u7f6e\u4e3a\u7a7a, \u8df3\u8fc7\u4e0a\u4f20");
            return;
        }
        OssCloudClient ossCloudClient = new OssCloudClient(bwmSaasConfiguration.getOss().getEndpoint(), bwmSaasConfiguration.getOss().getAk(), bwmSaasConfiguration.getOss().getSk());
        ossCloudClient.uploadAndMergeFolder(bwmSaasConfiguration.getOss().getBucket(), bwmSaasConfiguration.getOss().getRootPath(), bwmSaasConfiguration.getLocal().getOutputFileSaveRootPath());
        log.info("\u4e0a\u4f20\u6587\u4ef6\u5230OSS\u5b8c\u6210");
        ossCloudClient.createFile(bwmSaasConfiguration.getOss().getBucket(), bwmSaasConfiguration.getMigrationInstanceStatusFileOssPath(), "{\"status\":\"finish\"}");
    }

    private void readSetting() {
        JSONObject setting;
        if (StringUtils.isEmpty((CharSequence)this.taskContext.getMergeRules())) {
            return;
        }
        if (this.taskContext.getMergeMode() == null && (setting = JSONObject.parseObject((String)this.taskContext.getMergeRules())) != null && setting.containsKey("merge.mode")) {
            try {
                this.taskContext.setMergeMode(MergeTaskContext.MergeMode.getMergeMode(setting.getString("merge.mode")));
            }
            catch (Exception e) {
                log.warn("\u65e0\u6cd5\u89e3\u6790MergeMode\uff0c\u9ed8\u8ba4\u8bbe\u7f6e\u4e3aSOURCE_PRIORITY\uff0c\u5f02\u5e38\u503c:", (Object)setting.getString("merge.mode"));
                this.taskContext.setMergeMode(MergeTaskContext.MergeMode.SOURCE_PRIORITY);
            }
        }
        if (this.taskContext.getMergeWorkflowPropertyRules() == null) {
            this.taskContext.setMergeWorkflowPropertyRules(new HashMap<PackageDiffConstant.WorkflowPropertyType, PackageDiffConstant.SourceOrTarget>());
            setting = JSONObject.parseObject((String)this.taskContext.getMergeRules());
            if (setting != null && setting.containsKey("workflow.property.update")) {
                setting.getJSONObject("workflow.property.update").forEach((key, value) -> {
                    try {
                        this.taskContext.getMergeWorkflowPropertyRules().put(PackageDiffConstant.WorkflowPropertyType.getWorkflowPropertyType((String)key), PackageDiffConstant.SourceOrTarget.getSourceOrTarget((String)value.toString()));
                    }
                    catch (Exception e) {
                        Arrays.stream(PackageDiffConstant.WorkflowPropertyType.values()).forEach(type -> {
                            if (!this.taskContext.getMergeWorkflowPropertyRules().containsKey(type)) {
                                this.taskContext.getMergeWorkflowPropertyRules().put((PackageDiffConstant.WorkflowPropertyType)type, PackageDiffConstant.SourceOrTarget.SOURCE);
                            }
                        });
                        log.warn("\u65e0\u6cd5\u89e3\u6790WorkflowPropertyType-Source/Target\u914d\u7f6e\u5bf9\uff0c\u9ed8\u8ba4\u8bbe\u7f6e\u4e3aSOURCE\uff0c\u5f02\u5e38\u503c:{} - {}", key, value);
                    }
                });
            } else {
                log.warn("\u672a\u83b7\u53d6\u5230WorkflowPropertyType-Source/Target\u914d\u7f6e\u5bf9\uff0c\u9ed8\u8ba4\u8bbe\u7f6e\u4e3aSOURCE");
                Arrays.stream(PackageDiffConstant.WorkflowPropertyType.values()).forEach(type -> {
                    if (!this.taskContext.getMergeWorkflowPropertyRules().containsKey(type)) {
                        this.taskContext.getMergeWorkflowPropertyRules().put((PackageDiffConstant.WorkflowPropertyType)type, PackageDiffConstant.SourceOrTarget.SOURCE);
                    }
                });
            }
        }
        if (this.taskContext.getMergeNodePropertyRules() == null) {
            this.taskContext.setMergeNodePropertyRules(new HashMap<PackageDiffConstant.WorkflowNodePropertyType, PackageDiffConstant.SourceOrTarget>());
            setting = JSONObject.parseObject((String)this.taskContext.getMergeRules());
            if (setting != null && setting.containsKey("node.property.update")) {
                setting.getJSONObject("node.property.update").forEach((key, value) -> {
                    try {
                        this.taskContext.getMergeNodePropertyRules().put(PackageDiffConstant.WorkflowNodePropertyType.getWorkflowNodePropertyType((String)key), PackageDiffConstant.SourceOrTarget.getSourceOrTarget((String)value.toString()));
                    }
                    catch (Exception e) {
                        log.warn("\u65e0\u6cd5\u89e3\u6790NodePropertyType-Source/Target\u914d\u7f6e\u5bf9\uff0c\u9ed8\u8ba4\u8bbe\u7f6e\u4e3aSOURCE\uff0c\u5f02\u5e38\u503c:{} - {}", key, value);
                        Arrays.stream(PackageDiffConstant.WorkflowNodePropertyType.values()).forEach(type -> {
                            if (!this.taskContext.getMergeNodePropertyRules().containsKey(type)) {
                                this.taskContext.getMergeNodePropertyRules().put((PackageDiffConstant.WorkflowNodePropertyType)type, PackageDiffConstant.SourceOrTarget.SOURCE);
                            }
                        });
                    }
                });
            } else {
                log.warn("\u672a\u83b7\u53d6\u5230NodePropertyType-Source/Target\u914d\u7f6e\u5bf9\uff0c\u9ed8\u8ba4\u8bbe\u7f6e\u4e3aSOURCE");
                Arrays.stream(PackageDiffConstant.WorkflowNodePropertyType.values()).forEach(type -> {
                    if (!this.taskContext.getMergeNodePropertyRules().containsKey(type)) {
                        this.taskContext.getMergeNodePropertyRules().put((PackageDiffConstant.WorkflowNodePropertyType)type, PackageDiffConstant.SourceOrTarget.SOURCE);
                    }
                });
            }
        }
    }

    private void generateDiffAndConfict() {
        PackageDiffCompareTool packageDiffCompareTool = new PackageDiffCompareTool();
        List<DiffElement> srcDiffElementList = packageDiffCompareTool.compare(this.taskContext.getReadT1Pkg(), this.taskContext.getReadTPkg(), PackageDiffConstant.SourceOrTarget.SOURCE);
        List<DiffElement> cvtDiffElementList = packageDiffCompareTool.compare(this.taskContext.getConvertT1Pkg(), this.taskContext.getConvertTPkg(), PackageDiffConstant.SourceOrTarget.CONVERT);
        List<DiffElement> tgtDiffElementList = packageDiffCompareTool.compare(this.taskContext.getWriteT1Pkg(), this.taskContext.getDataworksTPkg(), PackageDiffConstant.SourceOrTarget.TARGET);
        if (srcDiffElementList == null) {
            log.warn("\u9700\u8981\u6bd4\u5bf9\u4e24\u6b21\u8fc1\u79fb\u7684Reader\u8f93\u51fa\u5305\uff0c\u4f46\u672a\u83b7\u53d6\u5230\u8c03\u5ea6\u6570\u636e\u5305");
        } else {
            log.info("ReaderDiff\u751f\u6210\u6210\u529f");
            this.taskContext.setSrcDiffElementList(srcDiffElementList);
        }
        if (cvtDiffElementList == null) {
            log.error("\u9700\u8981\u6bd4\u5bf9\u4e24\u6b21\u8fc1\u79fb\u7684Convert\u8f93\u51fa\u5305\uff0c\u4f46\u672a\u83b7\u53d6\u5230\u8c03\u5ea6\u6570\u636e\u5305");
        } else {
            log.info("ConvertDiff\u751f\u6210\u6210\u529f");
            this.taskContext.setCvtDiffElementList(cvtDiffElementList);
        }
        if (tgtDiffElementList == null) {
            log.error("\u9700\u8981\u6bd4\u5bf9\u4e24\u6b21\u8fc1\u79fb\u7684Writer\u8f93\u51fa\u5305\uff0c\u4f46\u672a\u83b7\u53d6\u5230\u8c03\u5ea6\u6570\u636e\u5305");
        } else {
            log.info("WriterDiff\u751f\u6210\u6210\u529f");
            this.taskContext.setTgtDiffElementList(tgtDiffElementList);
        }
        PackageDiffConflictTool packageDiffConflictTool = new PackageDiffConflictTool();
        List<DiffConflictPair> diffConflictPairs = packageDiffConflictTool.getConflictDiffIdPairs(cvtDiffElementList, tgtDiffElementList);
        if (diffConflictPairs == null) {
            log.error("\u6b32\u627e\u5230\u53cc\u7aefDiff\u7684\u51b2\u7a81\uff0c\u4f46\u672a\u83b7\u53d6\u5230Diff");
            this.taskContext.setDiffConflictPairs(new ArrayList<DiffConflictPair>());
        } else {
            log.info("DiffConflictPair\u751f\u6210\u6210\u529f");
            this.taskContext.setDiffConflictPairs(diffConflictPairs);
        }
    }

    private void merge() {
        log.info("\u5f00\u59cb\u6267\u884c\u5408\u5e76");
        PackageDiffExecuteTool packageDiffExecuteTool = new PackageDiffExecuteTool();
        WorkflowProjectPackage resultPackage = packageDiffExecuteTool.joinAllPackage(this.taskContext.getConvertTPkg(), this.taskContext.getConvertT1Pkg(), this.taskContext.getWriteT1Pkg(), this.taskContext.getDataworksTPkg());
        log.info("\u5f00\u59cb\u6267\u884cMerge");
        ArrayList<DiffElement> diffElements = new ArrayList<DiffElement>();
        diffElements.addAll(this.taskContext.getCvtDiffElementList());
        diffElements.addAll(this.taskContext.getTgtDiffElementList());
        List<String> effectDiffElementIds = packageDiffExecuteTool.listEffectDiffElementId(diffElements, this.taskContext.getDiffConflictPairs());
        packageDiffExecuteTool.executeDiff(diffElements, effectDiffElementIds, resultPackage);
        this.taskContext.setResultPkg(resultPackage);
    }

    private void readFile() {
        if (this.taskContext.getReadT1Pkg() != null) {
            log.info("TaskContext\u4e2d\u5df2\u83b7\u53d6\u5230\u4e0a\u6b21\u8fc1\u79fb\u7684Reader\u5305");
        } else if (!StringUtils.isEmpty((CharSequence)this.taskContext.getReaderOutputT1Path()) && this.taskContext.getReadT1Pkg() == null && new File(this.taskContext.getReaderOutputT1Path()).exists()) {
            log.info("\u5c1d\u8bd5\u4ece\u6587\u4ef6\u83b7\u53d6\u4e0a\u6b21\u8fc1\u79fb\u7684Reader\u5305");
            this.taskContext.setReadT1Pkg(BwmPackageFileOperator.readFile((String)this.taskContext.getReaderOutputT1Path()));
        } else {
            log.info("\u65e0\u6cd5\u83b7\u53d6\u4e0a\u6b21\u8fc1\u79fb\u7684Reader\u5305");
        }
        if (this.taskContext.getReadTPkg() != null) {
            log.info("TaskContext\u4e2d\u5df2\u83b7\u53d6\u5230\u672c\u6b21\u8fc1\u79fb\u7684Reader\u5305");
        } else if (!StringUtils.isEmpty((CharSequence)this.taskContext.getReaderOutputTPath()) && this.taskContext.getReadTPkg() == null && new File(this.taskContext.getReaderOutputTPath()).exists()) {
            log.info("\u5c1d\u8bd5\u4ece\u6587\u4ef6\u83b7\u53d6\u672c\u6b21\u8fc1\u79fb\u7684Reader\u5305");
            this.taskContext.setReadTPkg(BwmPackageFileOperator.readFile((String)this.taskContext.getReaderOutputTPath()));
        } else {
            log.info("\u65e0\u6cd5\u83b7\u53d6\u672c\u6b21\u8fc1\u79fb\u7684Reader\u5305");
        }
        if (this.taskContext.getConvertT1Pkg() != null) {
            log.info("TaskContext\u4e2d\u5df2\u83b7\u53d6\u5230\u4e0a\u6b21\u8fc1\u79fb\u7684Convert\u5305");
        } else if (!StringUtils.isEmpty((CharSequence)this.taskContext.getConvertOutputT1Path()) && this.taskContext.getConvertT1Pkg() == null && new File(this.taskContext.getConvertOutputT1Path()).exists()) {
            log.info("\u5c1d\u8bd5\u4ece\u6587\u4ef6\u83b7\u53d6\u4e0a\u6b21\u8fc1\u79fb\u7684Convert\u5305");
            this.taskContext.setConvertT1Pkg(BwmPackageFileOperator.readFile((String)this.taskContext.getConvertOutputT1Path(), (String)this.taskContext.getConvertOutputT1ExtendedScriptPath()));
        } else {
            log.info("\u65e0\u6cd5\u672a\u83b7\u53d6\u5230\u4e0a\u6b21\u8fc1\u79fb\u7684Convert\u5305");
        }
        if (this.taskContext.getConvertTPkg() != null) {
            log.info("TaskContext\u4e2d\u5df2\u83b7\u53d6\u5230\u672c\u6b21\u8fc1\u79fb\u7684Convert\u5305");
        } else if (!StringUtils.isEmpty((CharSequence)this.taskContext.getConvertOutputTPath()) && this.taskContext.getConvertTPkg() == null && new File(this.taskContext.getConvertOutputTPath()).exists()) {
            log.info("\u5c1d\u8bd5\u4ece\u6587\u4ef6\u83b7\u53d6\u672c\u6b21\u8fc1\u79fb\u7684Convert\u5305");
            this.taskContext.setConvertTPkg(BwmPackageFileOperator.readFile((String)this.taskContext.getConvertOutputTPath(), (String)this.taskContext.getConvertOUtputTExtendedScriptPath()));
        } else {
            log.info("\u65e0\u6cd5\u672a\u83b7\u53d6\u5230\u672c\u6b21\u8fc1\u79fb\u7684Convert\u5305");
        }
        if (this.taskContext.getWriteT1Pkg() != null) {
            log.info("TaskContext\u4e2d\u5df2\u83b7\u53d6\u5230\u4e0a\u6b21\u8fc1\u79fb\u7684Writer\u5305");
        } else if (!StringUtils.isEmpty((CharSequence)this.taskContext.getWriteOutputT1Path()) && this.taskContext.getWriteT1Pkg() == null && new File(this.taskContext.getWriteOutputT1Path()).exists()) {
            log.info("\u5c1d\u8bd5\u4ece\u6587\u4ef6\u83b7\u53d6\u4e0a\u6b21\u8fc1\u79fb\u7684Writer\u5305");
            this.taskContext.setWriteT1Pkg(BwmPackageFileOperator.readFile((String)this.taskContext.getWriteOutputT1Path()));
        } else {
            log.info("\u65e0\u6cd5\u83b7\u53d6\u5230\u4e0a\u6b21\u8fc1\u79fb\u7684Writer\u5305");
        }
        if (this.taskContext.getDataworksTPkg() != null) {
            log.info("TaskContext\u4e2d\u5df2\u83b7\u53d6\u5230\u5f53\u524dDataWorks Reader\u5305");
            PackageDiffCommonTools.RefreshIdInPackage(this.taskContext.getDataworksTPkg());
        } else if (!StringUtils.isEmpty((CharSequence)this.taskContext.getTargetOutputTPath()) && this.taskContext.getDataworksTPkg() == null && new File(this.taskContext.getTargetOutputTPath()).exists()) {
            log.info("\u5c1d\u8bd5\u4ece\u6587\u4ef6\u5f53\u524dDataWorks Reader\u5305");
            this.taskContext.setDataworksTPkg(BwmPackageFileOperator.readFile((String)this.taskContext.getTargetOutputTPath()));
            PackageDiffCommonTools.RefreshIdInPackage(this.taskContext.getDataworksTPkg());
        } else {
            log.info("\u65e0\u6cd5\u83b7\u53d6\u5230\u5f53\u524dDataWorks Reader\u5305");
        }
        if (this.taskContext.getSrcDiffElementList() != null || this.taskContext.getCvtDiffElementList() != null || this.taskContext.getTgtDiffElementList() != null || this.taskContext.getDiffConflictPairs() != null) {
            log.info("Merge\u62a5\u8868\u72b6\u6001\uff1aTaskContext\u4e2d\u5df2\u5b58\u5728");
            this.taskContext.setStage(1);
        } else if (!StringUtils.isEmpty((CharSequence)this.taskContext.getResultXlsFilePath()) && new File(this.taskContext.getResultXlsFilePath()).exists()) {
            log.info("Merge\u62a5\u8868\u72b6\u6001\uff1a\u5c1d\u8bd5\u4ece\u6587\u4ef6\u83b7\u53d6Merge\u62a5\u8868");
            ArrayList<DiffElement> srcDiffElementList = new ArrayList<DiffElement>();
            ArrayList<DiffElement> cvtDiffElementList = new ArrayList<DiffElement>();
            ArrayList<DiffElement> tgtDiffElementList = new ArrayList<DiffElement>();
            ArrayList<DiffConflictPair> diffConfictPairs = new ArrayList<DiffConflictPair>();
            PackageDiffFileOperator.getUserMergeChoose(new File(this.taskContext.getResultXlsFilePath()), srcDiffElementList, cvtDiffElementList, tgtDiffElementList, diffConfictPairs);
            this.taskContext.setSrcDiffElementList(srcDiffElementList);
            this.taskContext.setCvtDiffElementList(cvtDiffElementList);
            this.taskContext.setTgtDiffElementList(tgtDiffElementList);
            this.taskContext.setDiffConflictPairs(diffConfictPairs);
            this.taskContext.setStage(1);
        } else {
            log.info("Merge\u62a5\u8868\u72b6\u6001\uff1a\u672a\u83b7\u53d6\u5230Merge\u62a5\u8868");
            this.taskContext.setStage(0);
        }
    }
}

