/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.fluentjob.api.mapping;

import com.github.dozermapper.core.DozerConverter;
import com.github.dozermapper.core.Mapper;
import com.github.dozermapper.core.MapperAware;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import org.apache.oozie.fluentjob.api.Condition;
import org.apache.oozie.fluentjob.api.dag.DagNodeWithCondition;
import org.apache.oozie.fluentjob.api.dag.Decision;
import org.apache.oozie.fluentjob.api.dag.NodeBase;
import org.apache.oozie.fluentjob.api.generated.workflow.CASE;
import org.apache.oozie.fluentjob.api.generated.workflow.DECISION;
import org.apache.oozie.fluentjob.api.generated.workflow.DEFAULT;
import org.apache.oozie.fluentjob.api.generated.workflow.ObjectFactory;
import org.apache.oozie.fluentjob.api.generated.workflow.SWITCH;
import org.apache.oozie.fluentjob.api.mapping.RealChildLocator;

public class DecisionConverter
extends DozerConverter<Decision, DECISION>
implements MapperAware {
    private static final ObjectFactory OBJECT_FACTORY = new ObjectFactory();
    private Mapper mapper;

    public DecisionConverter() {
        super(Decision.class, DECISION.class);
    }

    public DECISION convertTo(Decision source, DECISION destination) {
        destination = this.ensureDestination(destination);
        this.mapName(source, destination);
        this.mapTransitions(source, destination);
        return destination;
    }

    public Decision convertFrom(DECISION source, Decision destination) {
        throw new UnsupportedOperationException("This mapping is not bidirectional.");
    }

    private Mapper checkAndGetMapper() {
        Objects.requireNonNull(this.mapper, "mapper should be set");
        return this.mapper;
    }

    public void setMapper(Mapper mapper) {
        this.mapper = mapper;
    }

    private void mapName(Decision source, DECISION destination) {
        String name = source.getName();
        destination.setName(name);
    }

    private void mapTransitions(Decision source, DECISION destination) {
        NodeBase defaultNode = source.getDefaultChild();
        Preconditions.checkState((defaultNode != null ? 1 : 0) != 0, (Object)"No default transition found.");
        NodeBase realDefaultNode = RealChildLocator.findRealChild(defaultNode);
        DEFAULT defaultCase = OBJECT_FACTORY.createDEFAULT();
        defaultCase.setTo(realDefaultNode.getName());
        destination.getSwitch().setDefault(defaultCase);
        List<DagNodeWithCondition> childrenIncludingDefault = source.getChildrenWithConditions();
        List<DagNodeWithCondition> children = childrenIncludingDefault.subList(0, childrenIncludingDefault.size() - 1);
        List<CASE> cases = destination.getSwitch().getCase();
        for (DagNodeWithCondition childWithCondition : children) {
            NodeBase child = childWithCondition.getNode();
            NodeBase realChild = RealChildLocator.findRealChild(child);
            Condition condition = childWithCondition.getCondition();
            DagNodeWithCondition realChildWithCondition = new DagNodeWithCondition(realChild, condition);
            CASE mappedCase = (CASE)this.checkAndGetMapper().map((Object)realChildWithCondition, CASE.class);
            cases.add(mappedCase);
        }
    }

    private DECISION ensureDestination(DECISION destination) {
        DECISION result = destination;
        if (result == null) {
            result = OBJECT_FACTORY.createDECISION();
        }
        if (result.getSwitch() == null) {
            SWITCH _switch = OBJECT_FACTORY.createSWITCH();
            result.setSwitch(_switch);
        }
        return result;
    }
}

