/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.fluentjob.api.dag;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.oozie.fluentjob.api.Condition;
import org.apache.oozie.fluentjob.api.ModifyOnce;
import org.apache.oozie.fluentjob.api.dag.Decision;
import org.apache.oozie.fluentjob.api.dag.Join;
import org.apache.oozie.fluentjob.api.dag.NodeBase;

public class Fork
extends NodeBase {
    private NodeBase parent = null;
    private final List<NodeBase> children = new ArrayList<NodeBase>();
    private final ModifyOnce<Join> closingJoin = new ModifyOnce();

    public Fork(String name) {
        super(name);
    }

    public NodeBase getParent() {
        return this.parent;
    }

    @Override
    public void addParent(NodeBase parent) {
        Preconditions.checkState((this.parent == null ? 1 : 0) != 0, (Object)"Fork nodes cannot have multiple parents.");
        this.parent = parent;
        parent.addChild(this);
    }

    @Override
    public void addParentWithCondition(Decision parent, Condition condition) {
        Preconditions.checkState((this.parent == null ? 1 : 0) != 0, (Object)"Fork nodes cannot have multiple parents.");
        this.parent = parent;
        parent.addChildWithCondition(this, condition);
    }

    @Override
    public void addParentDefaultConditional(Decision parent) {
        Preconditions.checkState((this.parent == null ? 1 : 0) != 0, (Object)"Fork nodes cannot have multiple parents.");
        this.parent = parent;
        parent.addDefaultChild(this);
    }

    @Override
    public void removeParent(NodeBase parent) {
        Preconditions.checkArgument((this.parent == parent ? 1 : 0) != 0, (Object)"Trying to remove a nonexistent parent.");
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
        this.parent = null;
    }

    @Override
    public void clearParents() {
        this.removeParent(this.parent);
    }

    @Override
    public List<NodeBase> getChildren() {
        return Collections.unmodifiableList(new ArrayList<NodeBase>(this.children));
    }

    Join getClosingJoin() {
        return this.closingJoin.get();
    }

    boolean isClosed() {
        return this.getClosingJoin() != null;
    }

    void close(Join join) {
        this.closingJoin.set(join);
    }

    @Override
    protected void addChild(NodeBase child) {
        this.children.add(child);
    }

    @Override
    protected void removeChild(NodeBase child) {
        Preconditions.checkArgument((boolean)this.children.remove(child), (Object)"Trying to remove a nonexistent child.");
    }
}

