/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.fluentjob.api.action;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.oozie.fluentjob.api.ModifyOnce;
import org.apache.oozie.fluentjob.api.action.ActionAttributesBuilder;
import org.apache.oozie.fluentjob.api.action.Builder;
import org.apache.oozie.fluentjob.api.action.Node;
import org.apache.oozie.fluentjob.api.action.NodeBuilderBaseImpl;
import org.apache.oozie.fluentjob.api.action.SubWorkflowAction;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class SubWorkflowActionBuilder
extends NodeBuilderBaseImpl<SubWorkflowActionBuilder>
implements Builder<SubWorkflowAction> {
    private final ModifyOnce<String> appPath;
    private final ModifyOnce<Boolean> propagateConfiguration;
    private final Map<String, ModifyOnce<String>> configuration;

    public static SubWorkflowActionBuilder create() {
        ModifyOnce<String> appPath = new ModifyOnce<String>();
        ModifyOnce<Boolean> propagateConfiguration = new ModifyOnce<Boolean>(false);
        LinkedHashMap<String, ModifyOnce<String>> configuration = new LinkedHashMap<String, ModifyOnce<String>>();
        return new SubWorkflowActionBuilder(null, appPath, propagateConfiguration, configuration);
    }

    public static SubWorkflowActionBuilder createFromExistingAction(SubWorkflowAction action) {
        ModifyOnce<String> appPath = new ModifyOnce<String>(action.getAppPath());
        ModifyOnce<Boolean> propagateConfiguration = new ModifyOnce<Boolean>(action.isPropagatingConfiguration());
        Map<String, ModifyOnce<String>> configuration = ActionAttributesBuilder.convertToModifyOnceMap(action.getConfiguration());
        return new SubWorkflowActionBuilder(action, appPath, propagateConfiguration, configuration);
    }

    SubWorkflowActionBuilder(SubWorkflowAction action, ModifyOnce<String> appPath, ModifyOnce<Boolean> propagateConfiguration, Map<String, ModifyOnce<String>> configuration) {
        super(action);
        this.appPath = appPath;
        this.propagateConfiguration = propagateConfiguration;
        this.configuration = configuration;
    }

    public SubWorkflowActionBuilder withAppPath(String appPath) {
        this.appPath.set(appPath);
        return this;
    }

    public SubWorkflowActionBuilder withPropagatingConfiguration() {
        this.propagateConfiguration.set(true);
        return this;
    }

    public SubWorkflowActionBuilder withoutPropagatingConfiguration() {
        this.propagateConfiguration.set(false);
        return this;
    }

    public SubWorkflowActionBuilder withConfigProperty(String key, String value) {
        ModifyOnce<String> mappedValue = this.configuration.get(key);
        if (mappedValue == null) {
            mappedValue = new ModifyOnce<String>(value);
            this.configuration.put(key, mappedValue);
        }
        mappedValue.set(value);
        return this;
    }

    @Override
    public SubWorkflowAction build() {
        Node.ConstructionData constructionData = this.getConstructionData();
        SubWorkflowAction instance = new SubWorkflowAction(constructionData, this.appPath.get(), this.propagateConfiguration.get(), ActionAttributesBuilder.convertToConfigurationMap(this.configuration));
        this.addAsChildToAllParents(instance);
        return instance;
    }

    @Override
    protected SubWorkflowActionBuilder getRuntimeSelfReference() {
        return this;
    }
}

