/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.fluentjob.api.action;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.oozie.fluentjob.api.ModifyOnce;
import org.apache.oozie.fluentjob.api.action.ActionAttributesBuilder;
import org.apache.oozie.fluentjob.api.action.Builder;
import org.apache.oozie.fluentjob.api.action.Launcher;
import org.apache.oozie.fluentjob.api.action.Node;
import org.apache.oozie.fluentjob.api.action.NodeBuilderBaseImpl;
import org.apache.oozie.fluentjob.api.action.Prepare;
import org.apache.oozie.fluentjob.api.action.SqoopAction;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class SqoopActionBuilder
extends NodeBuilderBaseImpl<SqoopActionBuilder>
implements Builder<SqoopAction> {
    private final ActionAttributesBuilder attributesBuilder;
    private final ModifyOnce<String> command;

    public static SqoopActionBuilder create() {
        ActionAttributesBuilder builder = ActionAttributesBuilder.create();
        ModifyOnce<String> command = new ModifyOnce<String>();
        return new SqoopActionBuilder(null, builder, command);
    }

    public static SqoopActionBuilder createFromExistingAction(SqoopAction action) {
        ActionAttributesBuilder builder = ActionAttributesBuilder.createFromExisting(action.getAttributes());
        ModifyOnce<String> command = new ModifyOnce<String>(action.getCommand());
        return new SqoopActionBuilder(action, builder, command);
    }

    public static SqoopActionBuilder createFromExistingAction(Node action) {
        ActionAttributesBuilder builder = ActionAttributesBuilder.createFromAction(action);
        ModifyOnce<String> command = new ModifyOnce<String>();
        return new SqoopActionBuilder(action, builder, command);
    }

    private SqoopActionBuilder(Node action, ActionAttributesBuilder attributesBuilder, ModifyOnce<String> command) {
        super(action);
        this.attributesBuilder = attributesBuilder;
        this.command = command;
    }

    public SqoopActionBuilder withResourceManager(String resourceManager) {
        this.attributesBuilder.withResourceManager(resourceManager);
        return this;
    }

    public SqoopActionBuilder withNameNode(String nameNode) {
        this.attributesBuilder.withNameNode(nameNode);
        return this;
    }

    public SqoopActionBuilder withPrepare(Prepare prepare) {
        this.attributesBuilder.withPrepare(prepare);
        return this;
    }

    public SqoopActionBuilder withLauncher(Launcher launcher) {
        this.attributesBuilder.withLauncher(launcher);
        return this;
    }

    public SqoopActionBuilder withJobXml(String jobXml) {
        this.attributesBuilder.withJobXml(jobXml);
        return this;
    }

    public SqoopActionBuilder withoutJobXml(String jobXml) {
        this.attributesBuilder.withoutJobXml(jobXml);
        return this;
    }

    public SqoopActionBuilder clearJobXmls() {
        this.attributesBuilder.clearJobXmls();
        return this;
    }

    public SqoopActionBuilder withConfigProperty(String key, String value) {
        this.attributesBuilder.withConfigProperty(key, value);
        return this;
    }

    public SqoopActionBuilder withCommand(String command) {
        this.command.set(command);
        return this;
    }

    public SqoopActionBuilder withArgument(String argument) {
        this.attributesBuilder.withArg(argument);
        return this;
    }

    public SqoopActionBuilder withoutArgument(String argument) {
        this.attributesBuilder.withoutArg(argument);
        return this;
    }

    public SqoopActionBuilder clearArguments() {
        this.attributesBuilder.clearArgs();
        return this;
    }

    public SqoopActionBuilder withFile(String file) {
        this.attributesBuilder.withFile(file);
        return this;
    }

    public SqoopActionBuilder withoutFile(String file) {
        this.attributesBuilder.withoutFile(file);
        return this;
    }

    public SqoopActionBuilder clearFiles() {
        this.attributesBuilder.clearFiles();
        return this;
    }

    public SqoopActionBuilder withArchive(String archive) {
        this.attributesBuilder.withArchive(archive);
        return this;
    }

    public SqoopActionBuilder withoutArchive(String archive) {
        this.attributesBuilder.withoutArchive(archive);
        return this;
    }

    public SqoopActionBuilder clearArchives() {
        this.attributesBuilder.clearArchives();
        return this;
    }

    @Override
    public SqoopAction build() {
        Node.ConstructionData constructionData = this.getConstructionData();
        SqoopAction instance = new SqoopAction(constructionData, this.attributesBuilder.build(), this.command.get());
        this.addAsChildToAllParents(instance);
        return instance;
    }

    @Override
    protected SqoopActionBuilder getRuntimeSelfReference() {
        return this;
    }
}

