/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.fluentjob.api.action;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.oozie.fluentjob.api.ModifyOnce;
import org.apache.oozie.fluentjob.api.action.ActionAttributesBuilder;
import org.apache.oozie.fluentjob.api.action.Builder;
import org.apache.oozie.fluentjob.api.action.Launcher;
import org.apache.oozie.fluentjob.api.action.Node;
import org.apache.oozie.fluentjob.api.action.NodeBuilderBaseImpl;
import org.apache.oozie.fluentjob.api.action.Prepare;
import org.apache.oozie.fluentjob.api.action.SparkAction;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class SparkActionBuilder
extends NodeBuilderBaseImpl<SparkActionBuilder>
implements Builder<SparkAction> {
    private final ActionAttributesBuilder attributesBuilder;
    private final ModifyOnce<String> master;
    private final ModifyOnce<String> mode;
    private final ModifyOnce<String> actionName;
    private final ModifyOnce<String> actionClass;
    private final ModifyOnce<String> jar;
    private final ModifyOnce<String> sparkOpts;

    public static SparkActionBuilder create() {
        ActionAttributesBuilder builder = ActionAttributesBuilder.create();
        ModifyOnce<String> master = new ModifyOnce<String>();
        ModifyOnce<String> mode = new ModifyOnce<String>();
        ModifyOnce<String> actionName = new ModifyOnce<String>();
        ModifyOnce<String> actionClass = new ModifyOnce<String>();
        ModifyOnce<String> jar = new ModifyOnce<String>();
        ModifyOnce<String> sparkOpts = new ModifyOnce<String>();
        return new SparkActionBuilder(null, builder, master, mode, actionName, actionClass, jar, sparkOpts);
    }

    public static SparkActionBuilder createFromExistingAction(SparkAction action) {
        ActionAttributesBuilder builder = ActionAttributesBuilder.createFromExisting(action.getAttributes());
        ModifyOnce<String> master = new ModifyOnce<String>(action.getMaster());
        ModifyOnce<String> mode = new ModifyOnce<String>(action.getMode());
        ModifyOnce<String> actionName = new ModifyOnce<String>(action.getActionName());
        ModifyOnce<String> actionClass = new ModifyOnce<String>(action.getActionClass());
        ModifyOnce<String> jar = new ModifyOnce<String>(action.getJar());
        ModifyOnce<String> sparkOpts = new ModifyOnce<String>(action.getSparkOpts());
        return new SparkActionBuilder(action, builder, master, mode, actionName, actionClass, jar, sparkOpts);
    }

    public static SparkActionBuilder createFromExistingAction(Node action) {
        ActionAttributesBuilder builder = ActionAttributesBuilder.createFromAction(action);
        ModifyOnce<String> master = new ModifyOnce<String>();
        ModifyOnce<String> mode = new ModifyOnce<String>();
        ModifyOnce<String> actionName = new ModifyOnce<String>();
        ModifyOnce<String> actionClass = new ModifyOnce<String>();
        ModifyOnce<String> jar = new ModifyOnce<String>();
        ModifyOnce<String> sparkOpts = new ModifyOnce<String>();
        return new SparkActionBuilder(action, builder, master, mode, actionName, actionClass, jar, sparkOpts);
    }

    SparkActionBuilder(Node action, ActionAttributesBuilder attributesBuilder, ModifyOnce<String> master, ModifyOnce<String> mode, ModifyOnce<String> actionName, ModifyOnce<String> actionClass, ModifyOnce<String> jar, ModifyOnce<String> sparkOpts) {
        super(action);
        this.attributesBuilder = attributesBuilder;
        this.master = master;
        this.mode = mode;
        this.actionName = actionName;
        this.actionClass = actionClass;
        this.jar = jar;
        this.sparkOpts = sparkOpts;
    }

    public SparkActionBuilder withResourceManager(String resourceManager) {
        this.attributesBuilder.withResourceManager(resourceManager);
        return this;
    }

    public SparkActionBuilder withNameNode(String nameNode) {
        this.attributesBuilder.withNameNode(nameNode);
        return this;
    }

    public SparkActionBuilder withPrepare(Prepare prepare) {
        this.attributesBuilder.withPrepare(prepare);
        return this;
    }

    public SparkActionBuilder withLauncher(Launcher launcher) {
        this.attributesBuilder.withLauncher(launcher);
        return this;
    }

    public SparkActionBuilder withJobXml(String jobXml) {
        this.attributesBuilder.withJobXml(jobXml);
        return this;
    }

    public SparkActionBuilder withoutJobXml(String jobXml) {
        this.attributesBuilder.withoutJobXml(jobXml);
        return this;
    }

    public SparkActionBuilder clearJobXmls() {
        this.attributesBuilder.clearJobXmls();
        return this;
    }

    public SparkActionBuilder withConfigProperty(String key, String value) {
        this.attributesBuilder.withConfigProperty(key, value);
        return this;
    }

    public SparkActionBuilder withMaster(String master) {
        this.master.set(master);
        return this;
    }

    public SparkActionBuilder withMode(String mode) {
        this.mode.set(mode);
        return this;
    }

    public SparkActionBuilder withActionName(String actionName) {
        this.actionName.set(actionName);
        return this;
    }

    public SparkActionBuilder withActionClass(String actionClass) {
        this.actionClass.set(actionClass);
        return this;
    }

    public SparkActionBuilder withJar(String jar) {
        this.jar.set(jar);
        return this;
    }

    public SparkActionBuilder withSparkOpts(String sparkOpts) {
        this.sparkOpts.set(sparkOpts);
        return this;
    }

    public SparkActionBuilder withArg(String arg) {
        this.attributesBuilder.withArg(arg);
        return this;
    }

    public SparkActionBuilder withoutArg(String arg) {
        this.attributesBuilder.withoutArg(arg);
        return this;
    }

    public SparkActionBuilder clearArgs() {
        this.attributesBuilder.clearArgs();
        return this;
    }

    public SparkActionBuilder withFile(String file) {
        this.attributesBuilder.withFile(file);
        return this;
    }

    public SparkActionBuilder withoutFile(String file) {
        this.attributesBuilder.withoutFile(file);
        return this;
    }

    public SparkActionBuilder clearFiles() {
        this.attributesBuilder.clearFiles();
        return this;
    }

    public SparkActionBuilder withArchive(String archive) {
        this.attributesBuilder.withArchive(archive);
        return this;
    }

    public SparkActionBuilder withoutArchive(String archive) {
        this.attributesBuilder.withoutArchive(archive);
        return this;
    }

    public SparkActionBuilder clearArchive() {
        this.attributesBuilder.clearArchives();
        return this;
    }

    @Override
    public SparkAction build() {
        Node.ConstructionData constructionData = this.getConstructionData();
        SparkAction instance = new SparkAction(constructionData, this.attributesBuilder.build(), this.master.get(), this.mode.get(), this.actionName.get(), this.actionClass.get(), this.jar.get(), this.sparkOpts.get());
        this.addAsChildToAllParents(instance);
        return instance;
    }

    @Override
    protected SparkActionBuilder getRuntimeSelfReference() {
        return this;
    }
}

