/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.fluentjob.api.action;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.oozie.fluentjob.api.action.ActionAttributes;
import org.apache.oozie.fluentjob.api.action.HasAttributes;
import org.apache.oozie.fluentjob.api.action.Launcher;
import org.apache.oozie.fluentjob.api.action.Node;
import org.apache.oozie.fluentjob.api.action.Prepare;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class PigAction
extends Node
implements HasAttributes {
    private final ActionAttributes attributes;
    private final String script;
    private final ImmutableList<String> params;

    PigAction(Node.ConstructionData constructionData, ActionAttributes attributes, String script, ImmutableList<String> params) {
        super(constructionData);
        this.attributes = attributes;
        this.script = script;
        this.params = params;
    }

    public String getResourceManager() {
        return this.attributes.getResourceManager();
    }

    public String getNameNode() {
        return this.attributes.getNameNode();
    }

    public Prepare getPrepare() {
        return this.attributes.getPrepare();
    }

    public Launcher getLauncher() {
        return this.attributes.getLauncher();
    }

    public List<String> getJobXmls() {
        return this.attributes.getJobXmls();
    }

    public String getConfigProperty(String property) {
        return this.attributes.getConfiguration().get(property);
    }

    public Map<String, String> getConfiguration() {
        return this.attributes.getConfiguration();
    }

    public String getScript() {
        return this.script;
    }

    public List<String> getParams() {
        return this.params;
    }

    public List<String> getArgs() {
        return this.attributes.getArgs();
    }

    public List<String> getFiles() {
        return this.attributes.getFiles();
    }

    public List<String> getArchives() {
        return this.attributes.getArchives();
    }

    @Override
    public ActionAttributes getAttributes() {
        return this.attributes;
    }
}

