/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.fluentjob.api.action;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.oozie.fluentjob.api.ModifyOnce;
import org.apache.oozie.fluentjob.api.action.ActionAttributesBuilder;
import org.apache.oozie.fluentjob.api.action.Builder;
import org.apache.oozie.fluentjob.api.action.JavaAction;
import org.apache.oozie.fluentjob.api.action.Launcher;
import org.apache.oozie.fluentjob.api.action.Node;
import org.apache.oozie.fluentjob.api.action.NodeBuilderBaseImpl;
import org.apache.oozie.fluentjob.api.action.Prepare;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class JavaActionBuilder
extends NodeBuilderBaseImpl<JavaActionBuilder>
implements Builder<JavaAction> {
    private final ActionAttributesBuilder attributesBuilder;
    private final ModifyOnce<String> mainClass;
    private final ModifyOnce<String> javaOptsString;
    private final List<String> javaOpts;

    public static JavaActionBuilder create() {
        ActionAttributesBuilder builder = ActionAttributesBuilder.create();
        ModifyOnce<String> mainClass = new ModifyOnce<String>();
        ModifyOnce<String> javaOptsString = new ModifyOnce<String>();
        ArrayList<String> javaOpts = new ArrayList<String>();
        return new JavaActionBuilder(null, builder, mainClass, javaOptsString, javaOpts);
    }

    public static JavaActionBuilder createFromExistingAction(JavaAction action) {
        ActionAttributesBuilder builder = ActionAttributesBuilder.createFromExisting(action.getAttributes());
        ModifyOnce<String> mainClass = new ModifyOnce<String>(action.getMainClass());
        ModifyOnce<String> javaOptsString = new ModifyOnce<String>(action.getJavaOptsString());
        ArrayList<String> javaOpts = new ArrayList<String>(action.getJavaOpts());
        return new JavaActionBuilder(action, builder, mainClass, javaOptsString, javaOpts);
    }

    public static JavaActionBuilder createFromExistingAction(Node action) {
        ActionAttributesBuilder builder = ActionAttributesBuilder.createFromAction(action);
        ModifyOnce<String> mainClass = new ModifyOnce<String>();
        ModifyOnce<String> javaOptsString = new ModifyOnce<String>();
        ArrayList<String> javaOpts = new ArrayList<String>();
        return new JavaActionBuilder(action, builder, mainClass, javaOptsString, javaOpts);
    }

    private JavaActionBuilder(Node action, ActionAttributesBuilder attributesBuilder, ModifyOnce<String> mainClass, ModifyOnce<String> javaOptsString, List<String> javaOpts) {
        super(action);
        this.attributesBuilder = attributesBuilder;
        this.mainClass = mainClass;
        this.javaOptsString = javaOptsString;
        this.javaOpts = javaOpts;
    }

    public JavaActionBuilder withResourceManager(String resourceManager) {
        this.attributesBuilder.withResourceManager(resourceManager);
        return this;
    }

    public JavaActionBuilder withNameNode(String nameNode) {
        this.attributesBuilder.withNameNode(nameNode);
        return this;
    }

    public JavaActionBuilder withPrepare(Prepare prepare) {
        this.attributesBuilder.withPrepare(prepare);
        return this;
    }

    public JavaActionBuilder withLauncher(Launcher launcher) {
        this.attributesBuilder.withLauncher(launcher);
        return this;
    }

    public JavaActionBuilder withJobXml(String jobXml) {
        this.attributesBuilder.withJobXml(jobXml);
        return this;
    }

    public JavaActionBuilder withoutJobXml(String jobXml) {
        this.attributesBuilder.withoutJobXml(jobXml);
        return this;
    }

    public JavaActionBuilder clearJobXmls() {
        this.attributesBuilder.clearJobXmls();
        return this;
    }

    public JavaActionBuilder withConfigProperty(String key, String value) {
        this.attributesBuilder.withConfigProperty(key, value);
        return this;
    }

    public JavaActionBuilder withMainClass(String mainClass) {
        this.mainClass.set(mainClass);
        return this;
    }

    public JavaActionBuilder withJavaOptsString(String javaOptsString) {
        this.javaOptsString.set(javaOptsString);
        return this;
    }

    public JavaActionBuilder withJavaOpt(String javaOpt) {
        this.javaOpts.add(javaOpt);
        return this;
    }

    public JavaActionBuilder withoutJavaOpt(String javaOpt) {
        this.javaOpts.remove(javaOpt);
        return this;
    }

    public JavaActionBuilder clearJavaOpts() {
        this.javaOpts.clear();
        return this;
    }

    public JavaActionBuilder withArg(String arg) {
        this.attributesBuilder.withArg(arg);
        return this;
    }

    public JavaActionBuilder withoutArg(String arg) {
        this.attributesBuilder.withoutArg(arg);
        return this;
    }

    public JavaActionBuilder clearArgs() {
        this.attributesBuilder.clearArgs();
        return this;
    }

    public JavaActionBuilder withFile(String file) {
        this.attributesBuilder.withFile(file);
        return this;
    }

    public JavaActionBuilder withoutFile(String file) {
        this.attributesBuilder.withoutFile(file);
        return this;
    }

    public JavaActionBuilder clearFiles() {
        this.attributesBuilder.clearFiles();
        return this;
    }

    public JavaActionBuilder withArchive(String archive) {
        this.attributesBuilder.withArchive(archive);
        return this;
    }

    public JavaActionBuilder withoutArchive(String archive) {
        this.attributesBuilder.withoutArchive(archive);
        return this;
    }

    public JavaActionBuilder clearArchives() {
        this.attributesBuilder.clearArchives();
        return this;
    }

    public JavaActionBuilder withCaptureOutput(Boolean captureOutput) {
        this.attributesBuilder.withCaptureOutput(captureOutput);
        return this;
    }

    @Override
    public JavaAction build() {
        Node.ConstructionData constructionData = this.getConstructionData();
        JavaAction instance = new JavaAction(constructionData, this.attributesBuilder.build(), this.mainClass.get(), this.javaOptsString.get(), (ImmutableList<String>)ImmutableList.copyOf(this.javaOpts));
        this.addAsChildToAllParents(instance);
        return instance;
    }

    @Override
    protected JavaActionBuilder getRuntimeSelfReference() {
        return this;
    }
}

