/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.fluentjob.api;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import guru.nidi.graphviz.engine.Format;
import guru.nidi.graphviz.engine.Graphviz;
import guru.nidi.graphviz.engine.GraphvizException;
import guru.nidi.graphviz.model.MutableGraph;
import guru.nidi.graphviz.parse.Parser;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.oozie.fluentjob.api.action.Node;
import org.apache.oozie.fluentjob.api.dag.Decision;
import org.apache.oozie.fluentjob.api.dag.Graph;
import org.apache.oozie.fluentjob.api.dag.NodeBase;
import org.apache.oozie.fluentjob.api.workflow.Workflow;

@SuppressFBWarnings(value={"WEAK_FILENAMEUTILS"}, justification="Directory name is private static final")
public class GraphVisualization {
    private static final String PARENT_FOLDER_NAME = "target/graphviz";
    private static final int PNG_WIDTH = 1024;

    public static String graphToDot(Graph graph) {
        return GraphVisualization.nodeBasesToDot(graph.getNodes());
    }

    private static String nodeBasesToDot(Collection<NodeBase> nodes) {
        StringBuilder builder = new StringBuilder();
        builder.append("digraph {\n");
        for (NodeBase node : nodes) {
            List<NodeBase> children = node.getChildren();
            String style = "";
            if (node instanceof Decision) {
                style = "[style=dashed];";
            }
            for (NodeBase child : children) {
                String s = String.format("\t\"%s\" -> \"%s\"%s%n", node.getName(), child.getName(), style);
                builder.append(s);
            }
        }
        builder.append("}");
        return builder.toString();
    }

    private static String workflowToDot(Workflow workflow) {
        return GraphVisualization.nodesToDot(workflow.getNodes());
    }

    private static String nodesToDot(Collection<Node> nodes) {
        StringBuilder builder = new StringBuilder();
        builder.append("digraph {\n");
        for (Node node : nodes) {
            List<Node> children = node.getAllChildren();
            String style = "";
            if (!node.getChildrenWithConditions().isEmpty()) {
                style = "[style=dashed];";
            }
            for (Node child : children) {
                builder.append(String.format("\t\"%s\" -> \"%s\"%s%n", node.getName(), child.getName(), style));
            }
        }
        builder.append("}");
        return builder.toString();
    }

    public static void graphToPng(Graph graph, String fileName) throws IOException {
        if (!GraphVisualization.isProperJDKVersion()) {
            System.err.println("JDK version is not correct, omitting generating PNG from graph.");
            return;
        }
        MutableGraph mg = Parser.read((String)GraphVisualization.graphToDot(graph));
        mg.setName(fileName);
        try {
            Graphviz.fromGraph((MutableGraph)mg).width(1024).render(Format.PNG).toFile(new File(PARENT_FOLDER_NAME, FilenameUtils.getName((String)fileName)));
        }
        catch (GraphvizException e) {
            throw new GraphvizException(String.format("Java version is %s", System.getProperty("java.version")), (Throwable)e);
        }
    }

    public static void workflowToPng(Workflow workflow, String fileName) throws IOException {
        if (!GraphVisualization.isProperJDKVersion()) {
            System.err.println("JDK version is not correct, omitting generating PNG from workflow.");
            return;
        }
        MutableGraph mg = Parser.read((String)GraphVisualization.workflowToDot(workflow));
        mg.setName(fileName);
        try {
            Graphviz.fromGraph((MutableGraph)mg).width(1024).render(Format.PNG).toFile(new File(PARENT_FOLDER_NAME, FilenameUtils.getName((String)fileName)));
        }
        catch (GraphvizException e) {
            throw new GraphvizException(String.format("Java version is %s", System.getProperty("java.version")), (Throwable)e);
        }
    }

    private static boolean isProperJDKVersion() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.8.0_")) {
            try {
                return Integer.parseInt(version.substring(6)) >= 40;
            }
            catch (NumberFormatException ignored) {
                return false;
            }
        }
        return true;
    }
}

