/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.fluentjob.api;

import com.google.common.base.Preconditions;

public class Condition {
    private final String condition;
    private final boolean isDefault;

    private Condition(String condition, boolean isDefault) {
        boolean bothFieldsSet = condition == null && !isDefault;
        boolean bothFieldsUnset = condition != null && isDefault;
        Preconditions.checkArgument((!bothFieldsSet && !bothFieldsUnset ? 1 : 0) != 0, (Object)"Exactly one of 'condition' and 'isDefault' must be non-null or true (respectively).");
        this.condition = condition;
        this.isDefault = isDefault;
    }

    public static Condition actualCondition(String condition) {
        Preconditions.checkArgument((condition != null ? 1 : 0) != 0, (Object)"The argument 'condition' must not be null.");
        return new Condition(condition, false);
    }

    public static Condition defaultCondition() {
        return new Condition(null, true);
    }

    public String getCondition() {
        return this.condition;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Condition other = (Condition)o;
        if (this.isDefault != other.isDefault) {
            return false;
        }
        return this.condition != null ? this.condition.equals(other.condition) : other.condition == null;
    }

    public int hashCode() {
        int result = this.condition != null ? this.condition.hashCode() : 0;
        result = 31 * result + (this.isDefault ? 1 : 0);
        return result;
    }
}

