/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.common.spec.writer.impl;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.aliyun.dataworks.common.spec.annotation.SpecWriter;
import com.aliyun.dataworks.common.spec.domain.SpecContext;
import com.aliyun.dataworks.common.spec.domain.enums.SpecVersion;
import com.aliyun.dataworks.common.spec.domain.interfaces.NodeIO;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNode;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNodeOutput;
import com.aliyun.dataworks.common.spec.domain.ref.SpecTable;
import com.aliyun.dataworks.common.spec.domain.ref.SpecVariable;
import com.aliyun.dataworks.common.spec.writer.SpecWriterContext;
import com.aliyun.dataworks.common.spec.writer.impl.DefaultJsonObjectWriter;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;

@SpecWriter
public class SpecNodeWriter
extends DefaultJsonObjectWriter<SpecNode> {
    public SpecNodeWriter(SpecWriterContext context) {
        super(context);
    }

    @Override
    public JSONObject write(SpecNode specObj, SpecWriterContext context) {
        JSONObject json = this.writeJsonObject(specObj, true);
        json.put((Object)"datasets", this.writeByWriter(specObj.getDatasets()));
        JSONObject inputs = this.writeIo(specObj.getInputs());
        json.put((Object)"inputs", (Object)inputs);
        JSONObject outputs = this.writeIo(specObj.getOutputs());
        json.put((Object)"outputs", (Object)outputs);
        json.put((Object)"runtimeResource", this.writeByWriter(specObj.getRuntimeResource()));
        json.put((Object)"script", this.writeByWriter(specObj.getScript()));
        json.put((Object)"trigger", this.writeByWriter(specObj.getTrigger()));
        if (CollectionUtils.isNotEmpty(specObj.getFunctions())) {
            json.put((Object)"functions", (Object)new JSONArray().fluentAddAll((Collection)ListUtils.emptyIfNull(specObj.getFunctions()).stream().map(this::writeByWriter).collect(Collectors.toList())));
        }
        if (CollectionUtils.isNotEmpty(specObj.getFileResources())) {
            json.put((Object)"fileResources", (Object)new JSONArray().fluentAddAll((Collection)ListUtils.emptyIfNull(specObj.getFileResources()).stream().map(this::writeByWriter).collect(Collectors.toList())));
        }
        List removeKeyList = json.keySet().stream().filter(entry -> Stream.of("param-hub", "do-while", "for-each").map(key -> key.replace("-", "")).anyMatch(key -> StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)entry))).collect(Collectors.toList());
        ListUtils.emptyIfNull(removeKeyList).forEach(arg_0 -> json.remove(arg_0));
        json.put((Object)"param-hub", this.writeByWriter(specObj.getParamHub()));
        json.put((Object)"do-while", this.writeByWriter(specObj.getDoWhile()));
        json.put((Object)"for-each", this.writeByWriter(specObj.getForeach()));
        json.put((Object)"paiflow", this.writeByWriter(specObj.getPaiflow()));
        json.put((Object)"branch", this.writeByWriter(specObj.getBranch()));
        json.put((Object)"join", this.writeByWriter(specObj.getJoin()));
        json.put((Object)"combined", this.writeByWriter(specObj.getCombined()));
        json.put((Object)"subflow", this.writeByWriter(specObj.getSubflow()));
        return json;
    }

    private <T extends NodeIO> JSONObject writeIo(List<T> ioList) {
        if (ioList == null) {
            return null;
        }
        JSONObject ioJson = new JSONObject();
        Map<Class, List<NodeIO>> ioGroup = ListUtils.emptyIfNull(ioList).stream().collect(Collectors.groupingBy(Object::getClass));
        ioGroup.keySet().stream().sorted(Comparator.comparing(Class::getSimpleName)).forEach(clz -> {
            String key;
            List ios = (List)ioGroup.get(clz);
            if (SpecTable.class.isAssignableFrom((Class<?>)clz)) {
                key = "tables";
            } else if (SpecNodeOutput.class.isAssignableFrom((Class<?>)clz)) {
                String contextVersion = Optional.ofNullable(this.context).map(SpecContext::getVersion).orElse(SpecVersion.V_1_1_0.getLabel());
                key = SpecVersion.V_1_0_0.getLabel().equalsIgnoreCase(contextVersion) ? "outputs" : "nodeOutputs";
            } else if (clz.equals(SpecVariable.class)) {
                key = "variables";
            } else {
                throw new RuntimeException("unsupported input type");
            }
            if (!ioJson.containsKey(key)) {
                ioJson.put((Object)key, (Object)new JSONArray());
            }
            JSONArray arr = ioJson.getJSONArray(key);
            ListUtils.emptyIfNull((List)ios).stream().map(this::writeByWriter).forEach(arg_0 -> arr.add(arg_0));
        });
        return ioJson;
    }
}

