/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.common.spec.writer.impl;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.aliyun.dataworks.common.spec.annotation.SpecWriter;
import com.aliyun.dataworks.common.spec.domain.noref.SpecFlowDepend;
import com.aliyun.dataworks.common.spec.writer.SpecWriterContext;
import com.aliyun.dataworks.common.spec.writer.impl.DefaultJsonObjectWriter;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SpecWriter
public class SpecFlowDependWriter
extends DefaultJsonObjectWriter<SpecFlowDepend> {
    private static final Logger log = LoggerFactory.getLogger(SpecFlowDependWriter.class);

    public SpecFlowDependWriter(SpecWriterContext context) {
        super(context);
    }

    @Override
    public JSONObject write(SpecFlowDepend specObj, SpecWriterContext context) {
        if (specObj.getNodeId() == null || specObj.getNodeId().getId() == null) {
            log.error("invalid spec flow depend: {}", (Object)JSON.toJSONString((Object)specObj));
            return null;
        }
        JSONObject json = this.writeJsonObject(specObj, true);
        json.put((Object)"nodeId", (Object)specObj.getNodeId().getId());
        Optional.ofNullable(this.buildJsonArray(specObj.getDepends())).ifPresent(depends -> json.put((Object)"depends", depends));
        Optional.ofNullable(this.buildJsonArray(specObj.getVariableDepends())).ifPresent(depends -> json.put((Object)"variableDepends", depends));
        return json;
    }
}

