/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.common.spec.utils;

import com.aliyun.dataworks.common.spec.domain.enums.VariableScopeType;
import com.aliyun.dataworks.common.spec.domain.enums.VariableType;
import com.aliyun.dataworks.common.spec.domain.ref.SpecVariable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class VariableUtils {
    public static final Pattern NO_KV_PAIR_PARA_VALUE = Pattern.compile("[\\s^]?-p\\s*\"");

    public static boolean isNoKvPairParaValue(String paraValue) {
        if (StringUtils.isBlank((CharSequence)paraValue)) {
            return false;
        }
        return NO_KV_PAIR_PARA_VALUE.matcher(paraValue).find();
    }

    public static List<SpecVariable> getVariables(String paraValue) {
        if (VariableUtils.isNoKvPairParaValue(paraValue)) {
            SpecVariable noKvPairVar = new SpecVariable();
            noKvPairVar.setName("-");
            noKvPairVar.setScope(VariableScopeType.NODE_PARAMETER);
            noKvPairVar.setType(VariableType.NO_KV_PAIR_EXPRESSION);
            noKvPairVar.setValue(paraValue);
            return Collections.singletonList(noKvPairVar);
        }
        AtomicInteger paraIndex = new AtomicInteger(1);
        return Arrays.stream(StringUtils.split((String)StringUtils.defaultString((String)paraValue, (String)""), (String)" ")).map(kvStr -> {
            SpecVariable var = new SpecVariable();
            var.setType(VariableType.SYSTEM);
            var.setScope(VariableScopeType.NODE_PARAMETER);
            String[] kv = StringUtils.split((String)kvStr, (String)"=");
            if (kv.length == 2) {
                var.setName(kv[0]);
                var.setValue(kv[1]);
                return var;
            }
            var.setValue((String)kvStr);
            var.setName(String.valueOf(paraIndex.getAndIncrement()));
            return var;
        }).collect(Collectors.toList());
    }
}

