/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.common.spec.utils;

import com.aliyun.dataworks.common.spec.SpecUtil;
import com.aliyun.dataworks.common.spec.domain.DataWorksWorkflowSpec;
import com.aliyun.dataworks.common.spec.domain.Specification;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNode;
import com.aliyun.dataworks.common.spec.domain.ref.SpecRuntimeResource;
import com.aliyun.dataworks.common.spec.domain.ref.SpecScript;
import com.aliyun.dataworks.common.spec.domain.ref.SpecVariable;
import com.aliyun.dataworks.common.spec.exception.SpecErrorCode;
import com.aliyun.dataworks.common.spec.exception.SpecException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class SpecValidateUtil {
    void validateDataworksWorkflowSpec(String specCode) {
        if (StringUtils.isBlank((CharSequence)specCode)) {
            throw new IllegalArgumentException("specCode is null");
        }
        Specification spec = SpecUtil.parseToDomain(specCode);
        if (spec == null || spec.getSpec() == null) {
            throw new IllegalArgumentException("spec is null");
        }
        if (CollectionUtils.isEmpty(((DataWorksWorkflowSpec)spec.getSpec()).getNodes())) {
            throw new IllegalArgumentException("spec nodes is empty");
        }
        for (SpecNode node : ((DataWorksWorkflowSpec)spec.getSpec()).getNodes()) {
            SpecScript script = node.getScript();
            if (script == null) {
                throw new IllegalArgumentException("script is null");
            }
            if (script.getParameters() != null) {
                for (SpecVariable variable : script.getParameters()) {
                    if (!StringUtils.isBlank((CharSequence)variable.getValue())) continue;
                    throw new SpecException(SpecErrorCode.VALIDATE_ERROR, "variable {" + variable.getName() + "} value not config");
                }
            }
            if (node.getRuntimeResource() == null) {
                throw new IllegalArgumentException("runtimeResource is null");
            }
            SpecRuntimeResource runtimeResource = node.getRuntimeResource();
            if (!StringUtils.isBlank((CharSequence)runtimeResource.getResourceGroupId())) continue;
            throw new SpecException(SpecErrorCode.VALIDATE_ERROR, "resourceGroupId not config");
        }
    }
}

