/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.common.spec.utils;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.aliyun.dataworks.common.spec.SpecUtil;
import com.aliyun.dataworks.common.spec.domain.DataWorksWorkflowSpec;
import com.aliyun.dataworks.common.spec.domain.Spec;
import com.aliyun.dataworks.common.spec.domain.SpecRefEntity;
import com.aliyun.dataworks.common.spec.domain.Specification;
import com.aliyun.dataworks.common.spec.domain.enums.SpecKind;
import com.aliyun.dataworks.common.spec.domain.enums.VariableType;
import com.aliyun.dataworks.common.spec.domain.interfaces.Input;
import com.aliyun.dataworks.common.spec.domain.interfaces.Output;
import com.aliyun.dataworks.common.spec.domain.noref.SpecDepend;
import com.aliyun.dataworks.common.spec.domain.noref.SpecFlowDepend;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNode;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNodeOutput;
import com.aliyun.dataworks.common.spec.domain.ref.SpecScript;
import com.aliyun.dataworks.common.spec.domain.ref.SpecVariable;
import com.aliyun.dataworks.common.spec.domain.ref.SpecWorkflow;
import com.aliyun.dataworks.common.spec.domain.ref.runtime.SpecScriptRuntime;
import com.aliyun.dataworks.common.spec.utils.UuidUtils;
import com.aliyun.dataworks.common.spec.writer.SpecWriterContext;
import com.google.common.base.Joiner;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlowSpecCopier {
    private static final Logger log = LoggerFactory.getLogger(FlowSpecCopier.class);
    private final Map<String, String> uuidMapping = new HashMap<String, String>();
    private final Map<String, String> outputMapping = new HashMap<String, String>();

    public Specification<Spec> copy(Specification<Spec> sourceSpec) {
        if (sourceSpec == null) {
            log.info("sourceSpec is null");
            return null;
        }
        Specification<Spec> deepCopy = SpecUtil.parseToDomain(SpecUtil.writeToSpec(sourceSpec));
        this.uuidMapping.clear();
        this.outputMapping.clear();
        return this.doSpecCopy(deepCopy);
    }

    private Specification<Spec> doSpecCopy(Specification<Spec> spec) {
        return Optional.ofNullable(spec.getSpec()).filter(sp -> sp instanceof DataWorksWorkflowSpec).map(sp -> (DataWorksWorkflowSpec)sp).map(dwSpec -> {
            this.adaptManualWorkflow(spec.getKind(), (DataWorksWorkflowSpec)dwSpec);
            Optional.ofNullable(dwSpec.getWorkflows()).flatMap(wfs -> ListUtils.emptyIfNull(dwSpec.getWorkflows()).stream().findFirst()).ifPresent(workflow -> {
                this.processSpecWorkflow(spec.getKind(), (SpecWorkflow)workflow);
                this.processSpecNodeUuidMapping(workflow.getNodes());
                this.processSpecNodes(spec.getKind(), (SpecWorkflow)workflow, workflow.getNodes());
                this.processSpecDependencies(workflow.getDependencies());
            });
            Optional.ofNullable(dwSpec.getNodes()).ifPresent(nodes -> {
                this.processSpecNodeUuidMapping((List<SpecNode>)nodes);
                this.processSpecNodes(spec.getKind(), null, (List<SpecNode>)nodes);
            });
            Optional.ofNullable(dwSpec.getFlow()).ifPresent(this::processSpecDependencies);
            this.resetDwSpec((DataWorksWorkflowSpec)dwSpec);
            spec.setMetadata(null);
            String copiedSpec = SpecUtil.writeToSpec(spec);
            log.info("copied spec: {}", (Object)copiedSpec);
            return SpecUtil.parseToDomain(copiedSpec);
        }).orElseThrow(() -> new RuntimeException("copy failed"));
    }

    private void processSpecNodeUuidMapping(List<SpecNode> specNodes) {
        ListUtils.emptyIfNull(specNodes).forEach(specNode -> {
            String newId = UuidUtils.genUuidWithoutHorizontalLine();
            String oldId = specNode.getId();
            this.uuidMapping.put(oldId, newId);
            this.outputMapping.put(oldId, newId);
            Optional.ofNullable(specNode.getInnerNodes()).ifPresent(this::processSpecNodeUuidMapping);
        });
    }

    private void processSpecWorkflow(String specKind, SpecWorkflow workflow) {
        String newFlowId = UuidUtils.genUuidWithoutHorizontalLine();
        String oldFlowId = workflow.getId();
        this.uuidMapping.put(oldFlowId, newFlowId);
        workflow.setId(newFlowId);
        workflow.setMetadata(null);
        ListUtils.emptyIfNull(workflow.getOutputs()).forEach(o -> this.processOutput((Output)o, oldFlowId, newFlowId, specKind));
        ListUtils.emptyIfNull(workflow.getInputs()).forEach(this::processInput);
        Optional.ofNullable(workflow.getScript()).ifPresent(this::processScript);
    }

    private void processScript(SpecScript script) {
        script.setId(null);
        ListUtils.emptyIfNull(script.getParameters()).forEach(var -> {
            this.processInput((Input)var);
            var.setId(null);
            Optional.ofNullable(var.getReferenceVariable()).ifPresent(refVar -> {
                if (VariableType.PASS_THROUGH.equals(var.getType())) {
                    refVar.setType(var.getType());
                }
                this.processInput((Input)refVar);
            });
        });
    }

    private void adaptManualWorkflow(String specKind, DataWorksWorkflowSpec dwSpec) {
        if (SpecKind.MANUAL_WORKFLOW.getLabel().equalsIgnoreCase(specKind) && CollectionUtils.isEmpty(dwSpec.getWorkflows())) {
            SpecWorkflow specWorkflow = new SpecWorkflow();
            specWorkflow.setId(dwSpec.getId());
            specWorkflow.setName(dwSpec.getName());
            specWorkflow.setOwner(dwSpec.getOwner());
            specWorkflow.setDescription(dwSpec.getDescription());
            specWorkflow.setType(dwSpec.getType());
            SpecScript script = new SpecScript();
            script.setPath("/");
            SpecScriptRuntime runtime = new SpecScriptRuntime();
            runtime.setCommand("MANUAL_WORKFLOW");
            script.setRuntime(runtime);
            script.setParameters(dwSpec.getVariables());
            specWorkflow.setScript(script);
            specWorkflow.setNodes(dwSpec.getNodes());
            specWorkflow.setDependencies(dwSpec.getFlow());
            dwSpec.setWorkflows(List.of(specWorkflow));
            dwSpec.setFlow(null);
            dwSpec.setNodes(null);
        }
    }

    private void resetDwSpec(DataWorksWorkflowSpec dwSpec) {
        dwSpec.setId(null);
        dwSpec.setName(null);
        dwSpec.setType(null);
        dwSpec.setOwner(null);
        dwSpec.setDescription(null);
        dwSpec.setVariables(null);
        dwSpec.setMetadata(null);
    }

    private void processSpecDependencies(List<SpecFlowDepend> dependencies) {
        ListUtils.emptyIfNull(dependencies).forEach(dependency -> {
            Optional.ofNullable(dependency.getNodeId()).filter(node -> this.uuidMapping.containsKey(node.getId())).ifPresent(node -> {
                log.info("replace dependency.nodeId: {}, to new nodeId: {}", (Object)node.getId(), (Object)this.uuidMapping.get(node.getId()));
                node.setId(this.uuidMapping.get(node.getId()));
            });
            ListUtils.emptyIfNull(dependency.getDepends()).forEach(depend -> {
                Optional.ofNullable(depend.getOutput()).filter(out -> this.outputMapping.containsKey(out.getData())).ifPresent(output -> {
                    log.info("replace dependency.depends.output: {}, to new output: {}", (Object)depend.getOutput(), (Object)this.outputMapping.get(output.getData()));
                    output.setData(this.outputMapping.get(output.getData()));
                });
                Optional.ofNullable(depend.getNodeId()).filter(node -> this.uuidMapping.containsKey(node.getId())).ifPresent(nodeId -> {
                    log.info("replace dependency.depends.nodeId: {}, to new nodeId: {}", (Object)depend.getOutput(), (Object)this.uuidMapping.get(nodeId.getId()));
                    nodeId.setId(this.uuidMapping.get(nodeId.getId()));
                });
            });
        });
    }

    private void processSpecNodes(String specKind, SpecWorkflow workflow, List<SpecNode> specNodes) {
        ListUtils.emptyIfNull(specNodes).forEach(specNode -> {
            String oldId = specNode.getId();
            String newId = this.uuidMapping.get(specNode.getId());
            specNode.setId(newId);
            Optional.ofNullable(specNode.getScript()).ifPresent(this::processScript);
            ListUtils.emptyIfNull(specNode.getOutputs()).forEach(out -> this.processOutput((Output)out, oldId, newId, specKind));
            ListUtils.emptyIfNull(specNode.getInputs()).forEach(this::processInput);
            specNode.setMetadata(null);
            Optional.ofNullable(specNode.getInnerNodes()).filter(CollectionUtils::isNotEmpty).ifPresent(innerNodes -> this.processSpecNodes(specKind, null, (List<SpecNode>)innerNodes));
            Optional.ofNullable(specNode.getInnerDependencies()).filter(CollectionUtils::isNotEmpty).ifPresent(this::processSpecDependencies);
            Optional.ofNullable(specNode.getSubflow()).ifPresent(subflow -> {
                Optional.ofNullable(subflow.getOutput()).map(this.outputMapping::get).or(() -> Optional.ofNullable(subflow.getId()).map(this.uuidMapping::get)).ifPresent(subflow::setOutput);
                subflow.setId(null);
            });
            Optional.ofNullable(specNode.getJoin()).ifPresent(join -> ListUtils.emptyIfNull(join.getBranches()).forEach(branch -> Optional.ofNullable(branch.getOutput()).map(o -> this.outputMapping.get(o.getData())).ifPresent(o -> branch.getOutput().setData((String)o))));
            Optional.ofNullable(specNode.getParamHub()).ifPresent(paramHub -> ListUtils.emptyIfNull(paramHub.getVariables()).stream().filter(var -> VariableType.PASS_THROUGH.equals(var.getType())).forEach(this::processPassThroughVariable));
            Optional.ofNullable(specNode.getBranch()).ifPresent(branch -> ListUtils.emptyIfNull(branch.getBranches()).forEach(b -> Optional.ofNullable(b.getOutput()).map(o -> this.outputMapping.get(o.getData())).ifPresent(o -> b.getOutput().setData((String)o))));
            Optional.ofNullable(specNode.getForeach()).ifPresent(foreach -> specNode.getScript().setContent(JSONObject.toJSONString((Object)SpecUtil.write(foreach, new SpecWriterContext()), (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.PrettyFormat})));
            Optional.ofNullable(specNode.getDoWhile()).ifPresent(dowhile -> specNode.getScript().setContent(JSONObject.toJSONString((Object)SpecUtil.write(dowhile, new SpecWriterContext()), (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.PrettyFormat})));
            Optional.ofNullable(specNode.getCombined()).ifPresent(combine -> specNode.getScript().setContent(JSONObject.toJSONString((Object)SpecUtil.write(combine, new SpecWriterContext()), (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.PrettyFormat})));
            Optional.ofNullable(specNode.getParamHub()).ifPresent(paramHub -> specNode.getScript().setContent(JSONObject.toJSONString((Object)SpecUtil.write(paramHub, new SpecWriterContext()), (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.PrettyFormat})));
            Optional.ofNullable(specNode.getBranch()).ifPresent(branch -> this.outputMapping.forEach((oldOut, newOut) -> {
                String newContent = StringUtils.replaceIgnoreCase((String)specNode.getScript().getContent(), (String)("\"" + oldOut + "\""), (String)("\"" + newOut + "\""));
                specNode.getScript().setContent(newContent);
            }));
            Optional.ofNullable(specNode.getJoin()).ifPresent(join -> this.outputMapping.forEach((oldOut, newOut) -> {
                String newContent = StringUtils.replaceIgnoreCase((String)specNode.getScript().getContent(), (String)("\\\"" + oldOut + "\\\""), (String)("\\\"" + newOut + "\\\""));
                specNode.getScript().setContent(newContent);
            }));
        });
    }

    private void processPassThroughVariable(SpecVariable passThroughVar) {
        if (!VariableType.PASS_THROUGH.equals(passThroughVar.getType())) {
            return;
        }
        String[] outputAndName = StringUtils.split((String)passThroughVar.getValue(), (String)":");
        if (outputAndName.length > 1 && this.outputMapping.containsKey(outputAndName[0])) {
            passThroughVar.setValue(Joiner.on((String)":").join((Object)this.outputMapping.get(outputAndName[0]), (Object)outputAndName[1], new Object[0]));
        }
        Optional.ofNullable(passThroughVar.getReferenceVariable()).map(SpecVariable::getNode).filter(node -> node.getOutput() != null && this.outputMapping.containsKey(node.getOutput().getData())).ifPresent(refVarNode -> refVarNode.getOutput().setData(this.outputMapping.get(refVarNode.getOutput().getData())));
    }

    private void processInput(Input input) {
        SpecNodeOutput nodeInput;
        if (input instanceof SpecNodeOutput && this.outputMapping.containsKey((nodeInput = (SpecNodeOutput)input).getData())) {
            log.info("found nodeInput: {} in outputMapping, replace to output: {}", (Object)nodeInput.getData(), (Object)this.outputMapping.get(nodeInput.getData()));
            nodeInput.setData(this.outputMapping.get(nodeInput.getData()));
        }
        if (input instanceof SpecVariable) {
            SpecVariable variable = (SpecVariable)input;
            variable.setId(null);
            this.processPassThroughVariable(variable);
            SpecDepend node = Optional.ofNullable(variable.getNode()).orElse(new SpecDepend());
            String outputStr = Optional.ofNullable(node.getOutput()).map(SpecNodeOutput::getData).or(() -> Optional.ofNullable(node.getNodeId()).map(SpecRefEntity::getId)).orElse(null);
            if (StringUtils.isBlank((CharSequence)outputStr)) {
                log.warn("variable nodeInput: {} is empty, skip", (Object)outputStr);
                return;
            }
            SpecNodeOutput output = new SpecNodeOutput();
            output.setData(outputStr);
            if (this.outputMapping.containsKey(outputStr) || this.uuidMapping.containsValue(outputStr)) {
                log.info("found variable nodeInput: {} in outputMapping, replace to output: {}", (Object)output, (Object)this.outputMapping.get(outputStr));
                output.setData(this.outputMapping.get(outputStr));
            }
            node.setNodeId(null);
            node.setOutput(output);
            Optional.ofNullable(variable.getReferenceVariable()).ifPresent(refVar -> {
                refVar.setId(null);
                refVar.setNode(node);
            });
        }
    }

    private void processOutput(Output out, String oldId, String newId, String specKind) {
        if (out instanceof SpecNodeOutput) {
            SpecNodeOutput nodeOutput = (SpecNodeOutput)out;
            if (StringUtils.equalsIgnoreCase((CharSequence)nodeOutput.getData(), (CharSequence)oldId)) {
                nodeOutput.setData(newId);
                this.outputMapping.put(oldId, newId);
            } else if (SpecKind.CYCLE_WORKFLOW.getLabel().equalsIgnoreCase(specKind)) {
                String oldOutput = nodeOutput.getData();
                String newOutput = Joiner.on((String)"_").join((Object)nodeOutput.getData(), (Object)newId, new Object[0]);
                log.info("replace node output: {} to: {}", (Object)oldOutput, (Object)newOutput);
                nodeOutput.setData(newOutput);
                this.outputMapping.put(oldOutput, newOutput);
            }
        }
        if (out instanceof SpecVariable) {
            SpecVariable variable = (SpecVariable)out;
            variable.setId(null);
            Optional.ofNullable(variable.getNode()).ifPresent(n -> n.setNodeId(null));
            variable.setReferenceVariable(null);
            SpecDepend node = Optional.ofNullable(variable.getNode()).orElse(new SpecDepend());
            SpecNodeOutput output = new SpecNodeOutput();
            output.setData(newId);
            node.setOutput(output);
            this.processPassThroughVariable(variable);
        }
    }

    public Map<String, String> getUuidMapping() {
        return this.uuidMapping;
    }

    public Map<String, String> getOutputMapping() {
        return this.outputMapping;
    }
}

