/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.common.spec.parser.impl;

import com.aliyun.dataworks.common.spec.annotation.SpecParser;
import com.aliyun.dataworks.common.spec.domain.enums.SpecStorageType;
import com.aliyun.dataworks.common.spec.domain.ref.SpecFile;
import com.aliyun.dataworks.common.spec.domain.ref.file.SpecHdfsFile;
import com.aliyun.dataworks.common.spec.domain.ref.file.SpecObjectStorageFile;
import com.aliyun.dataworks.common.spec.domain.ref.file.SpecOssFile;
import com.aliyun.dataworks.common.spec.parser.Parser;
import com.aliyun.dataworks.common.spec.parser.SpecParserContext;
import com.aliyun.dataworks.common.spec.utils.MapKeyMatchUtils;
import com.aliyun.dataworks.common.spec.utils.SpecDevUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

@SpecParser
public class FileListParser
implements Parser<List<SpecFile>> {
    public static final String KEY_TYPE = "files";

    @Override
    public List<SpecFile> parse(Map<String, Object> rawContext, SpecParserContext specParserContext) {
        List hdfsFiles;
        ArrayList<SpecFile> specFiles = new ArrayList<SpecFile>();
        List ossFiles = (List)MapKeyMatchUtils.getValue(rawContext, StringUtils::equalsIgnoreCase, SpecStorageType.OSS.getLabel());
        if (CollectionUtils.isNotEmpty((Collection)ossFiles)) {
            for (Map file : ossFiles) {
                Map storage = !file.containsKey("storage") ? new LinkedHashMap() : (Map)file.get("storage");
                storage.put("type", SpecStorageType.OSS.getLabel());
                file.put("storage", storage);
                SpecOssFile specOssFile = (SpecOssFile)SpecDevUtil.getObjectByParser(SpecObjectStorageFile.class, file, specParserContext);
                specFiles.add(specOssFile);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(hdfsFiles = (List)MapKeyMatchUtils.getValue(rawContext, StringUtils::equalsIgnoreCase, SpecStorageType.HDFS.getLabel())))) {
            for (Map output : hdfsFiles) {
                Map storage = !output.containsKey("storage") ? new LinkedHashMap() : (Map)output.get("storage");
                storage.put("type", SpecStorageType.HDFS.getLabel());
                output.put("storage", storage);
                SpecHdfsFile hdfsFile = (SpecHdfsFile)SpecDevUtil.getObjectByParser(SpecObjectStorageFile.class, output, specParserContext);
                specFiles.add(hdfsFile);
            }
        }
        return specFiles;
    }

    @Override
    public String getKeyType() {
        return KEY_TYPE;
    }
}

