/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.common.spec.domain.ref.file;

import com.aliyun.dataworks.common.spec.domain.enums.SpecStorageType;
import com.aliyun.dataworks.common.spec.domain.ref.SpecFile;
import com.aliyun.dataworks.common.spec.domain.ref.storage.SpecStorage;
import com.aliyun.dataworks.common.spec.exception.SpecErrorCode;
import com.aliyun.dataworks.common.spec.exception.SpecException;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections4.SetUtils;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class SpecObjectStorageFile
extends SpecFile {
    private static final Set<Class<? extends SpecObjectStorageFile>> subClz;
    private SpecStorage storage;

    public static SpecObjectStorageFile newInstanceOf(SpecStorageType storageType) {
        if (storageType == null) {
            return null;
        }
        return SetUtils.emptyIfNull(subClz).stream().map(clz -> {
            try {
                return (SpecObjectStorageFile)clz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }).filter(clz -> Objects.equals(storageType, clz.getStorage().getType())).findFirst().orElseThrow(() -> new SpecException(SpecErrorCode.PARSE_ERROR, "storage type not supported: " + storageType));
    }

    public SpecStorage getStorage() {
        return this.storage;
    }

    public void setStorage(SpecStorage storage) {
        this.storage = storage;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpecObjectStorageFile)) {
            return false;
        }
        SpecObjectStorageFile other = (SpecObjectStorageFile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpecStorage this$storage = this.getStorage();
        SpecStorage other$storage = other.getStorage();
        return !(this$storage == null ? other$storage != null : !((Object)this$storage).equals(other$storage));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof SpecObjectStorageFile;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        SpecStorage $storage = this.getStorage();
        result = result * 59 + ($storage == null ? 43 : ((Object)$storage).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "SpecObjectStorageFile(super=" + super.toString() + ", storage=" + this.getStorage() + ")";
    }

    static {
        Reflections reflections = new Reflections(SpecObjectStorageFile.class.getPackage().getName(), new Scanner[0]);
        subClz = reflections.getSubTypesOf(SpecObjectStorageFile.class);
    }
}

