/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.common.spec.domain.dw.types;

import com.aliyun.dataworks.common.spec.domain.dw.types.LocaleAware;
import java.util.Locale;

public enum ModelTreeRoot implements LocaleAware
{
    ALL_ROOT("allroot", "\u6839\u76ee\u5f55", "", "allroot"),
    BIZ_ROOT("bizroot", "\u4e1a\u52a1\u6d41\u7a0b", "Business Flow", "biz"),
    MANUAL_BIZ_ROOT("manualbizroot", "\u624b\u52a8\u4e1a\u52a1\u6d41\u7a0b", "Manual Business Flow", "manualbiz"),
    WORK_FLOW_ROOT_NEW("workflowroot", "\u65e7\u7248\u5de5\u4f5c\u6d41", "Workflow", "workflow"),
    WORK_FLOW_ROOT("workflowroot", "\u5de5\u4f5c\u6d41", "Workflow", "workflow"),
    MANUAL_WORK_FLOW_ROOT("manualworkflowroot", "\u624b\u52a8\u5de5\u4f5c\u6d41", "Manual Workflow", "manualworkflow"),
    ONCE_ROOT("onceroot", "\u624b\u52a8\u4efb\u52a1", "Manual Tasks", "manualtask"),
    QUERY_ROOT("queryroot", "\u4e34\u65f6\u67e5\u8be2", "Queries", "adhocquery"),
    COMPONENT_ROOT("componentroot", "\u7ec4\u4ef6", "Components", "");

    private final String rootKey;
    private final String name;
    private final String englishName;
    private final String module;

    private ModelTreeRoot(String rootKey, String name, String englishName, String module) {
        this.rootKey = rootKey;
        this.name = name;
        this.englishName = englishName;
        this.module = module;
    }

    public static ModelTreeRoot searchModelTreeRoot(String keyword) {
        for (ModelTreeRoot root : ModelTreeRoot.values()) {
            if (root.equals(ALL_ROOT) || !root.getRootKey().equalsIgnoreCase(keyword) && !root.getName().equalsIgnoreCase(keyword) && !root.getEnglishName().equalsIgnoreCase(keyword) && !root.getModule().equalsIgnoreCase(keyword)) continue;
            return root;
        }
        return null;
    }

    public boolean matches(String keyword) {
        return this.getRootKey().equalsIgnoreCase(keyword) || this.getName().equalsIgnoreCase(keyword) || this.getEnglishName().equalsIgnoreCase(keyword) || this.getModule().equalsIgnoreCase(keyword);
    }

    @Override
    public String getDisplayName(Locale locale) {
        if (Locale.SIMPLIFIED_CHINESE.equals(locale)) {
            return this.getName();
        }
        return this.getEnglishName();
    }

    public String getRootKey() {
        return this.rootKey;
    }

    public String getName() {
        return this.name;
    }

    public String getEnglishName() {
        return this.englishName;
    }

    public String getModule() {
        return this.module;
    }
}

