/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.common.spec.domain.dw.nodemodel;

import com.alibaba.fastjson2.JSON;
import com.aliyun.dataworks.common.spec.domain.DataWorksWorkflowSpec;
import com.aliyun.dataworks.common.spec.domain.SpecRefEntity;
import com.aliyun.dataworks.common.spec.domain.Specification;
import com.aliyun.dataworks.common.spec.domain.dw.nodemodel.InputContext;
import com.aliyun.dataworks.common.spec.domain.dw.nodemodel.OutputContext;
import com.aliyun.dataworks.common.spec.domain.dw.nodemodel.SpecEntityDelegate;
import com.aliyun.dataworks.common.spec.domain.enums.ArtifactType;
import com.aliyun.dataworks.common.spec.domain.enums.DependencyType;
import com.aliyun.dataworks.common.spec.domain.interfaces.Input;
import com.aliyun.dataworks.common.spec.domain.interfaces.Output;
import com.aliyun.dataworks.common.spec.domain.noref.SpecDepend;
import com.aliyun.dataworks.common.spec.domain.noref.SpecFlowDepend;
import com.aliyun.dataworks.common.spec.domain.ref.SpecArtifact;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNode;
import com.aliyun.dataworks.common.spec.domain.ref.SpecNodeOutput;
import com.aliyun.dataworks.common.spec.domain.ref.SpecScript;
import com.aliyun.dataworks.common.spec.domain.ref.SpecVariable;
import com.aliyun.dataworks.common.spec.domain.ref.SpecWorkflow;
import com.aliyun.dataworks.common.spec.exception.SpecErrorCode;
import com.aliyun.dataworks.common.spec.exception.SpecException;
import com.google.common.base.Joiner;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataWorksNodeInputOutputAdapter {
    private static final Logger log = LoggerFactory.getLogger(DataWorksNodeInputOutputAdapter.class);
    protected final Specification<DataWorksWorkflowSpec> spec;
    private final SpecEntityDelegate<? extends SpecRefEntity> objectDelegate;

    public DataWorksNodeInputOutputAdapter(Specification<DataWorksWorkflowSpec> specification, SpecRefEntity entity) {
        this.spec = specification;
        this.objectDelegate = new SpecEntityDelegate<SpecRefEntity>(entity);
    }

    public List<Input> getInputs() {
        List nodes = ListUtils.emptyIfNull((List)Optional.ofNullable(this.spec).map(Specification::getSpec).map(DataWorksWorkflowSpec::getNodes).orElse(null));
        SpecNode outerNode = nodes.stream().filter(node -> ListUtils.emptyIfNull(node.getInnerNodes()).stream().anyMatch(innerNode -> StringUtils.equals((CharSequence)innerNode.getId(), (CharSequence)this.objectDelegate.getId()))).findAny().orElse(null);
        if (outerNode != null) {
            return this.getInputList(outerNode.getInnerDependencies(), outerNode.getInnerNodes(), this.objectDelegate);
        }
        SpecWorkflow outerWorkflow = Optional.ofNullable(this.spec).map(Specification::getSpec).map(DataWorksWorkflowSpec::getWorkflows).flatMap(wfs -> wfs.stream().filter(wf -> ListUtils.emptyIfNull(wf.getNodes()).stream().anyMatch(n -> StringUtils.equalsIgnoreCase((CharSequence)n.getId(), (CharSequence)this.objectDelegate.getId()))).findFirst()).orElse(null);
        if (outerWorkflow != null) {
            return this.getInputList(outerWorkflow.getDependencies(), outerWorkflow.getNodes(), this.objectDelegate);
        }
        SpecNode container = Optional.ofNullable(this.spec).map(Specification::getSpec).map(DataWorksWorkflowSpec::getWorkflows).map(wfs -> wfs.stream().map(wf -> ListUtils.emptyIfNull(wf.getNodes())).collect(Collectors.toList())).orElse(ListUtils.emptyIfNull(null)).stream().flatMap(Collection::stream).filter(containerNode -> ListUtils.emptyIfNull(containerNode.getInnerNodes()).stream().anyMatch(n -> StringUtils.equalsIgnoreCase((CharSequence)n.getId(), (CharSequence)this.objectDelegate.getId()))).findAny().orElse(null);
        if (container != null) {
            return this.getInputList(container.getInnerDependencies(), container.getInnerNodes(), this.objectDelegate);
        }
        return this.getInputList(Optional.ofNullable(this.spec).map(Specification::getSpec).map(DataWorksWorkflowSpec::getFlow).orElse(null), nodes, this.objectDelegate);
    }

    private List<Input> getInputList(List<SpecFlowDepend> flow, List<SpecNode> allNodes, SpecEntityDelegate<?> node) {
        List<Input> inputs = ListUtils.emptyIfNull(node.getInputs()).stream().filter(o -> o instanceof SpecNodeOutput).map(o -> (SpecArtifact)o).filter(o -> ArtifactType.NODE_OUTPUT.equals(o.getArtifactType())).collect(Collectors.toList());
        Optional<SpecFlowDepend> specNodeFlowDepend = ListUtils.emptyIfNull(flow).stream().filter(fd -> StringUtils.equalsIgnoreCase((CharSequence)node.getId(), (CharSequence)fd.getNodeId().getId())).peek(fd -> log.info("node flow depends source nodeId: {}, depends: {}", (Object)JSON.toJSONString((Object)fd.getNodeId()), (Object)JSON.toJSONString(fd.getDepends()))).findFirst();
        specNodeFlowDepend.map(SpecFlowDepend::getDepends).orElse(ListUtils.emptyIfNull(null)).stream().filter(dep -> DependencyType.NORMAL.equals(dep.getType())).filter(dep -> dep.getOutput() == null || StringUtils.isBlank((CharSequence)dep.getOutput().getData())).filter(dep -> dep.getNodeId() != null).map(dep -> ListUtils.emptyIfNull((List)allNodes).stream().filter(n -> StringUtils.equals((CharSequence)dep.getNodeId().getId(), (CharSequence)n.getId())).findAny().flatMap(depNode -> depNode.getOutputs().stream().filter(o -> o instanceof SpecNodeOutput).map(o -> (SpecNodeOutput)o).findAny()).map(output -> {
            SpecNodeOutput io = new SpecNodeOutput();
            io.setData(output.getData());
            io.setRefTableName(output.getRefTableName());
            io.setSourceType(dep.getSourceType());
            return io;
        }).orElse(null)).filter(Objects::nonNull).forEach(inputs::add);
        specNodeFlowDepend.map(SpecFlowDepend::getDepends).orElse(ListUtils.emptyIfNull(null)).stream().filter(dep -> DependencyType.NORMAL.equals(dep.getType())).map(dep -> Optional.ofNullable(dep.getOutput()).map(out -> {
            SpecNodeOutput io = new SpecNodeOutput();
            io.setData(out.getData());
            io.setRefTableName(out.getRefTableName());
            io.setSourceType(dep.getSourceType());
            return io;
        }).orElse(null)).filter(Objects::nonNull).forEach(inputs::add);
        return inputs;
    }

    public List<Output> getOutputs() {
        return ListUtils.emptyIfNull(this.objectDelegate.getOutputs()).stream().filter(o -> o instanceof SpecArtifact).map(o -> (SpecArtifact)o).filter(o -> ArtifactType.NODE_OUTPUT.equals(o.getArtifactType())).collect(Collectors.toList());
    }

    public List<InputContext> getInputContexts() {
        return ListUtils.emptyIfNull(this.objectDelegate.getInputs()).stream().filter(i -> i instanceof SpecArtifact).filter(i -> ArtifactType.VARIABLE.equals(((SpecArtifact)i).getArtifactType())).map(i -> (SpecVariable)i).map(i -> {
            InputContext inCtx = new InputContext();
            inCtx.setKey(this.getInputContextKey((SpecVariable)i));
            inCtx.setRefKey(DataWorksNodeInputOutputAdapter.getIoContextRefKey(i, false));
            return inCtx;
        }).collect(Collectors.toList());
    }

    private String getInputContextKey(SpecVariable i) {
        return (String)Optional.ofNullable(this.objectDelegate.getScript()).map(SpecScript::getParameters).flatMap(params -> params.stream().filter(param -> param.getReferenceVariable() != null).filter(param -> DataWorksNodeInputOutputAdapter.matchVariable(i, param.getReferenceVariable())).map(SpecVariable::getName).findAny()).or(() -> Optional.ofNullable(i.getInputName())).orElseThrow(() -> new SpecException(SpecErrorCode.PARSE_ERROR, "inputs variable missing binding in script.parameters: " + i.getName()));
    }

    private static boolean matchVariable(SpecVariable varA, SpecVariable varB) {
        if (!StringUtils.isBlank((CharSequence)varA.getId()) && !StringUtils.isBlank((CharSequence)varB.getId())) {
            return StringUtils.equals((CharSequence)varA.getId(), (CharSequence)varB.getId());
        }
        if (varA.getNode() != null && varB.getNode() != null) {
            if (varA.getNode().getOutput() != null && varB.getNode().getOutput() != null) {
                return StringUtils.equalsIgnoreCase((CharSequence)varA.getNode().getOutput().getData(), (CharSequence)varB.getNode().getOutput().getData()) && StringUtils.equals((CharSequence)varA.getName(), (CharSequence)varB.getName());
            }
            if (varA.getNode().getNodeId() != null && varB.getNode().getNodeId() != null) {
                return StringUtils.equals((CharSequence)varA.getNode().getNodeId().getId(), (CharSequence)varB.getNode().getNodeId().getId()) && StringUtils.equals((CharSequence)varA.getName(), (CharSequence)varB.getName());
            }
        }
        log.warn("variable identifier missing, cannot compare and match variable: {} and variable: {}", (Object)varA, (Object)varB);
        throw new SpecException(SpecErrorCode.PARSE_ERROR, "variable identifier missing, cannot compare and match variable: " + varA + " and variable: " + varB);
    }

    private static String getIoContextRefKey(SpecVariable i, boolean isOutput) {
        return Optional.ofNullable(i.getReferenceVariable()).map(refVar -> {
            String varName = Optional.ofNullable(refVar.getName()).orElseThrow(() -> new SpecException(SpecErrorCode.PARSE_ERROR, "context variable field error, missing 'variable.referenceVariable.name'"));
            String output = Optional.ofNullable(refVar.getNode()).map(SpecDepend::getOutput).map(SpecNodeOutput::getData).orElseThrow(() -> new SpecException(SpecErrorCode.PARSE_ERROR, "context variable field error, missing 'variable.referenceVariable.node.output'"));
            return Joiner.on((String)":").join((Object)output, (Object)varName, new Object[0]);
        }).orElseGet(() -> {
            if (BooleanUtils.isTrue((Boolean)isOutput)) {
                return i.getValue();
            }
            String output = Optional.ofNullable(i.getNode()).map(SpecDepend::getOutput).map(SpecNodeOutput::getData).orElseThrow(() -> new SpecException(SpecErrorCode.PARSE_ERROR, "context variable field error, missing 'variable.node.output'"));
            return Joiner.on((String)":").join((Object)output, (Object)i.getName(), new Object[0]);
        });
    }

    public List<OutputContext> getOutputContexts() {
        return ListUtils.emptyIfNull(this.objectDelegate.getOutputs()).stream().filter(i -> i instanceof SpecArtifact).filter(i -> ArtifactType.VARIABLE.equals(((SpecArtifact)i).getArtifactType())).map(i -> (SpecVariable)i).map(i -> {
            OutputContext outCtx = new OutputContext();
            outCtx.setKey(i.getName());
            switch (i.getType()) {
                case CONSTANT: {
                    outCtx.setCtxType("CONST");
                    outCtx.setValueExpr(i.getValue());
                    break;
                }
                case SYSTEM: {
                    outCtx.setCtxType("SYSTEM_VARIABLE");
                    outCtx.setValueExpr(i.getValue());
                    break;
                }
                case NODE_OUTPUT: {
                    outCtx.setCtxType("SCRIPT_OUTPUTS");
                    outCtx.setValueExpr(i.getValue());
                    break;
                }
                case PAI_OUTPUT: {
                    outCtx.setCtxType("PAI_OUTPUTS");
                    outCtx.setValueExpr(i.getName());
                    break;
                }
                case PASS_THROUGH: {
                    outCtx.setCtxType("PARAMETER_NODE_OUTPUTS");
                    outCtx.setValueExpr(DataWorksNodeInputOutputAdapter.getIoContextRefKey(i.getReferenceVariable(), true));
                }
            }
            return outCtx;
        }).collect(Collectors.toList());
    }
}

