/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.common.spec.domain.dw.codemodel;

import com.aliyun.dataworks.common.spec.domain.dw.codemodel.AbstractBaseCode;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.utils.GsonUtils;
import com.google.common.base.Joiner;
import com.google.gson.reflect.TypeToken;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class OdpsSparkCode
extends AbstractBaseCode {
    public static final String SPARK_VERSION_2X = "2.x";
    public static final String SPARK_VERSION_1X = "1.x";
    public static final String SPARK_LANGUAGE_JAVA = "java";
    public static final String SPARK_LANGUAGE_PY = "python";
    private CodeJson sparkJson;

    @Override
    public OdpsSparkCode parse(String code) {
        if (StringUtils.isEmpty((CharSequence)code)) {
            return this;
        }
        List<String> resourceNames = Arrays.stream(code.trim().split("\n")).filter(line -> line.matches("##@resource_reference\\{\"([^\\{|^\\}]+)\"\\}")).map(line -> line.replace("##@resource_reference{\"", "").replace("\"}", "")).collect(Collectors.toList());
        OdpsSparkCode model = new OdpsSparkCode();
        model.setResourceReferences(resourceNames);
        String json = Joiner.on((String)"\\n").join((Iterable)Arrays.stream(code.split("\n")).filter(line -> !line.matches("##@resource_reference\\{\"([^\\{|^\\}]+)\"\\}")).collect(Collectors.toList()));
        CodeJson codeJson = (CodeJson)GsonUtils.gson.fromJson(json, new TypeToken<CodeJson>(){}.getType());
        model.setSparkJson(codeJson);
        this.setResourceReferences(model.getResourceReferences());
        this.setSparkJson(model.getSparkJson());
        return this;
    }

    @Override
    public List<String> getProgramTypes() {
        return Collections.singletonList(CodeProgramType.ODPS_SPARK.name());
    }

    public CodeJson getSparkJson() {
        return this.sparkJson;
    }

    public void setSparkJson(CodeJson sparkJson) {
        this.sparkJson = sparkJson;
    }

    @Override
    public String getContent() {
        StringBuilder code = new StringBuilder();
        if (!CollectionUtils.isEmpty((Collection)this.resourceReferences)) {
            String refs = Joiner.on((String)"\n").join((Iterable)this.resourceReferences.stream().map(str -> "##@resource_reference{\"" + str + "\"}").collect(Collectors.toList()));
            code.append(refs);
            code.append("\n");
        }
        if (this.sparkJson != null) {
            code.append(GsonUtils.defaultGson.toJson((Object)this.sparkJson));
        }
        return code.toString();
    }

    @Override
    public String toString() {
        StringBuilder code = new StringBuilder();
        if (!CollectionUtils.isEmpty((Collection)this.resourceReferences)) {
            String refs = Joiner.on((String)"\n").join((Iterable)this.resourceReferences.stream().map(str -> "##@resource_reference{\"" + str + "\"}").collect(Collectors.toList()));
            code.append(refs);
            code.append("\n");
        }
        if (this.sparkJson != null) {
            code.append(GsonUtils.defaultGson.toJson((Object)this.sparkJson));
        }
        return code.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OdpsSparkCode)) {
            return false;
        }
        OdpsSparkCode other = (OdpsSparkCode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CodeJson this$sparkJson = this.getSparkJson();
        CodeJson other$sparkJson = other.getSparkJson();
        return !(this$sparkJson == null ? other$sparkJson != null : !this$sparkJson.equals(other$sparkJson));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof OdpsSparkCode;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        CodeJson $sparkJson = this.getSparkJson();
        result = result * 59 + ($sparkJson == null ? 43 : $sparkJson.hashCode());
        return result;
    }

    public static class CodeJson {
        private String version = "2.x";
        private String language;
        private String mainClass;
        private String args;
        private List<String> configs;
        private String mainJar;
        private String mainPy;
        private List<String> assistPys;
        private List<String> assistJars;
        private List<String> assistFiles;
        private List<String> assistArchives;
        private List<String> archivesName;

        public String getMainPy() {
            return this.mainPy;
        }

        public void setMainPy(String mainPy) {
            this.mainPy = mainPy;
        }

        public List<String> getAssistPys() {
            return this.assistPys;
        }

        public void setAssistPys(List<String> assistPys) {
            this.assistPys = assistPys;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getLanguage() {
            return this.language;
        }

        public void setLanguage(String language) {
            this.language = language;
        }

        public String getMainClass() {
            return this.mainClass;
        }

        public void setMainClass(String mainClass) {
            this.mainClass = mainClass;
        }

        public String getArgs() {
            return this.args;
        }

        public void setArgs(String args) {
            this.args = args;
        }

        public List<String> getConfigs() {
            return this.configs;
        }

        public void setConfigs(List<String> configs) {
            this.configs = configs;
        }

        public String getMainJar() {
            return this.mainJar;
        }

        public void setMainJar(String mainJar) {
            this.mainJar = mainJar;
        }

        public List<String> getAssistJars() {
            return this.assistJars;
        }

        public void setAssistJars(List<String> assistJars) {
            this.assistJars = assistJars;
        }

        public List<String> getAssistFiles() {
            return this.assistFiles;
        }

        public void setAssistFiles(List<String> assistFiles) {
            this.assistFiles = assistFiles;
        }

        public List<String> getAssistArchives() {
            return this.assistArchives;
        }

        public void setAssistArchives(List<String> assistArchives) {
            this.assistArchives = assistArchives;
        }

        public List<String> getArchivesName() {
            return this.archivesName;
        }

        public void setArchivesName(List<String> archivesName) {
            this.archivesName = archivesName;
        }
    }
}

