/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.common.spec.domain.dw.codemodel;

import com.aliyun.dataworks.common.spec.domain.dw.codemodel.AbstractBaseCode;
import com.aliyun.dataworks.common.spec.domain.dw.codemodel.SqlComponentCode;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.domain.ref.component.SpecComponent;
import com.aliyun.dataworks.common.spec.domain.ref.component.SpecComponentParameter;
import com.aliyun.dataworks.common.spec.utils.GsonUtils;
import com.google.gson.annotations.JsonAdapter;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentSqlCode
extends AbstractBaseCode {
    private static final Logger log = LoggerFactory.getLogger(ComponentSqlCode.class);
    private String code;
    @JsonAdapter(value=SqlComponentCode.ComponentAdapter.class)
    private SpecComponent config;
    private ComponentInfo component;

    @Override
    public ComponentSqlCode parse(String content) {
        ComponentSqlCode componentSqlCode;
        try {
            componentSqlCode = Optional.ofNullable(GsonUtils.fromJsonString(content, ComponentSqlCode.class)).map(c -> (ComponentSqlCode)c).orElse(new ComponentSqlCode());
        }
        catch (Exception e) {
            log.warn("parse component sql code error: {}, code: {}", (Object)e.getMessage(), (Object)content);
            componentSqlCode = new ComponentSqlCode();
        }
        if (StringUtils.isNotBlank((CharSequence)content)) {
            this.code = componentSqlCode.getCode();
            this.config = componentSqlCode.getConfig();
            this.component = componentSqlCode.getComponent();
            this.programType = componentSqlCode.getProgramType();
            this.resourceReferences = componentSqlCode.getResourceReferences();
        }
        return componentSqlCode;
    }

    @Override
    public List<String> getProgramTypes() {
        return Collections.singletonList(CodeProgramType.COMPONENT_SQL.name());
    }

    @Override
    public String getSourceCode() {
        return this.mergeSqlComponentParamsIntoCode();
    }

    @Override
    public void setSourceCode(String sourceCode) {
        this.code = sourceCode;
    }

    public String mergeSqlComponentParamsIntoCode() {
        if (this.config == null) {
            return this.code;
        }
        return ComponentSqlCode.renderCode(ComponentSqlCode.renderCode(this.code, this.config.getInputs()), this.config.getOutputs());
    }

    public static String renderCode(String code, List<SpecComponentParameter> parameters) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return code;
        }
        try {
            String resultCode = code;
            for (SpecComponentParameter input : ListUtils.emptyIfNull(parameters)) {
                resultCode = StringUtils.replace((String)resultCode, (String)("@@{" + input.getName() + "}"), (String)input.getValue());
            }
            return resultCode;
        }
        catch (Exception e) {
            log.error("Malformed sql component code content|ErrMsg={}", (Object)e.getMessage(), (Object)e);
            return code;
        }
    }

    public String getCode() {
        return this.code;
    }

    public SpecComponent getConfig() {
        return this.config;
    }

    public ComponentInfo getComponent() {
        return this.component;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setConfig(SpecComponent config) {
        this.config = config;
    }

    public void setComponent(ComponentInfo component) {
        this.component = component;
    }

    @Override
    public String toString() {
        return "ComponentSqlCode(code=" + this.getCode() + ", config=" + this.getConfig() + ", component=" + this.getComponent() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ComponentSqlCode)) {
            return false;
        }
        ComponentSqlCode other = (ComponentSqlCode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        SpecComponent this$config = this.getConfig();
        SpecComponent other$config = other.getConfig();
        if (this$config == null ? other$config != null : !((Object)this$config).equals(other$config)) {
            return false;
        }
        ComponentInfo this$component = this.getComponent();
        ComponentInfo other$component = other.getComponent();
        return !(this$component == null ? other$component != null : !((Object)this$component).equals(other$component));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ComponentSqlCode;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        SpecComponent $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
        ComponentInfo $component = this.getComponent();
        result = result * 59 + ($component == null ? 43 : ((Object)$component).hashCode());
        return result;
    }

    public static class ComponentInfo {
        private Long id;
        private Integer version;
        private String name;

        public Long getId() {
            return this.id;
        }

        public Integer getVersion() {
            return this.version;
        }

        public String getName() {
            return this.name;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public void setVersion(Integer version) {
            this.version = version;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ComponentInfo)) {
                return false;
            }
            ComponentInfo other = (ComponentInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$id = this.getId();
            Long other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            Integer this$version = this.getVersion();
            Integer other$version = other.getVersion();
            if (this$version == null ? other$version != null : !((Object)this$version).equals(other$version)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ComponentInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            Integer $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : ((Object)$version).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        public String toString() {
            return "ComponentSqlCode.ComponentInfo(id=" + this.getId() + ", version=" + this.getVersion() + ", name=" + this.getName() + ")";
        }
    }
}

