/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.converter.dsv3.convert;

import com.aliyun.dataworks.common.spec.domain.dw.codemodel.ControllerBranchCode;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.model.SwitchResultVo;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.switchs.SwitchParameters;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.convert.AbstractNodeConvert;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import com.aliyun.migrationx.common.utils.JSONUtils;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SwitchNodeConvert
extends AbstractNodeConvert {
    private static final Logger log = LoggerFactory.getLogger(SwitchNodeConvert.class);

    public SwitchNodeConvert(TaskContext taskContext, Workflow workflow) {
        super(taskContext);
        this.workflow = workflow;
    }

    public List<WorkflowNode> convert(List<WorkflowNode> workflowNodes) {
        if (CollectionUtils.isEmpty(workflowNodes)) {
            log.warn("node convert workflowNodes is null");
            return new ArrayList<WorkflowNode>();
        }
        ArrayList<WorkflowNode> tgtNodes = new ArrayList<WorkflowNode>();
        WorkflowNode workflowNode = workflowNodes.get(0);
        WorkflowNode tgtworkflowNode = (WorkflowNode)BwmJsonUtil.deepCopy((Object)workflowNode, WorkflowNode.class);
        tgtworkflowNode.setNodeType(CodeProgramType.CONTROLLER_BRANCH.getName());
        JsonNode param = (JsonNode)JSONUtils.parseObject((String)workflowNode.getScript(), JsonNode.class);
        SwitchParameters switchParameters = null;
        if (param.get("switchResult") != null) {
            switchParameters = (SwitchParameters)JSONUtils.parseObject((JsonNode)param.get("switchResult"), SwitchParameters.class);
        }
        if (switchParameters == null || switchParameters.getDependTaskList() == null || switchParameters.getDependTaskList().isEmpty()) {
            log.warn("no dependence param {}", (Object)workflowNode.getScript());
            return Arrays.asList(tgtworkflowNode);
        }
        Long defaultNextCode = switchParameters.getNextNode();
        ArrayList<ControllerBranchCode.Branch> branchList = new ArrayList<ControllerBranchCode.Branch>();
        for (SwitchResultVo switchResultVo : switchParameters.getDependTaskList()) {
            String condition = switchResultVo.getCondition();
            Long nextNodeCode = switchResultVo.getNextNode();
            List nextNodes = this.workflow.getWorkflowNodes().stream().filter(node -> node.getNodeId().equals(String.valueOf(nextNodeCode))).collect(Collectors.toList());
            WorkflowNode branchTask = null;
            if (CollectionUtils.isNotEmpty(nextNodes)) {
                branchTask = (WorkflowNode)nextNodes.get(0);
            }
            if (branchTask == null) continue;
            ControllerBranchCode.Branch branch = new ControllerBranchCode.Branch();
            branch.setCondition(condition);
            String taskId = branchTask.getNodeId();
            String output = this.getDefaultNodeOutput(tgtworkflowNode.getNodeId() + "to" + taskId);
            branch.setNodeoutput(output);
            branchList.add(branch);
        }
        ControllerBranchCode branchCode = new ControllerBranchCode();
        branchCode.setBranchList(branchList);
        tgtworkflowNode.setScript(branchCode.getContent());
        this.supplyBaseMsg(tgtworkflowNode);
        tgtNodes.add(tgtworkflowNode);
        return tgtNodes;
    }
}

