/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.converter.dsv3.convert;

import com.alibaba.fastjson2.JSONObject;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.enums.DbType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.sql.SqlParameters;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowDatasource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.convert.AbstractNodeConvert;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlNodeConvert
extends AbstractNodeConvert {
    private static final Logger log = LoggerFactory.getLogger(SqlNodeConvert.class);

    public SqlNodeConvert(TaskContext taskContext, Workflow workflow) {
        super(taskContext);
        this.workflow = workflow;
    }

    public List<WorkflowNode> convert(List<WorkflowNode> workflowNodes) {
        if (CollectionUtils.isEmpty(workflowNodes)) {
            log.warn("node convert workflowNodes is null");
            return new ArrayList<WorkflowNode>();
        }
        WorkflowNode workflowNode = workflowNodes.get(0);
        ArrayList<WorkflowNode> tgtNodes = new ArrayList<WorkflowNode>();
        WorkflowNode tgtworkflowNode = (WorkflowNode)BwmJsonUtil.deepCopy((Object)workflowNode, WorkflowNode.class);
        if (Objects.isNull(tgtworkflowNode)) {
            log.error("convert tgt node error, result is null");
            tgtNodes.add(workflowNode);
            return tgtNodes;
        }
        if (Objects.isNull(workflowNode.getCustomProperties())) {
            workflowNode.setCustomProperties(new HashMap());
        }
        tgtworkflowNode.setNodeType(this.getNodeType(workflowNode));
        String codeProgramType = this.getDbType(workflowNode);
        tgtworkflowNode.setDbType(codeProgramType);
        this.getNodeParam(workflowNode, tgtworkflowNode);
        this.chooseDataSource(workflowNode, tgtworkflowNode, codeProgramType);
        if (codeProgramType.equals(CodeProgramType.ODPS_SQL.name())) {
            tgtworkflowNode.setNodeType(CodeProgramType.ODPS_SQL.name());
        } else if (CodeProgramType.EMR_HIVE.name().equals(codeProgramType) || CodeProgramType.EMR_SPARK.name().equals(codeProgramType) || CodeProgramType.EMR_SPARK_SQL.name().equals(codeProgramType) || CodeProgramType.EMR_IMPALA.name().equals(codeProgramType) || CodeProgramType.EMR_KYUUBI.name().equals(codeProgramType) || CodeProgramType.EMR_PRESTO.name().equals(codeProgramType)) {
            tgtworkflowNode.setScript(SqlNodeConvert.wfToEmrCode((WorkflowNode)tgtworkflowNode));
            tgtworkflowNode.setNodeType(codeProgramType);
        } else if (codeProgramType.equals(CodeProgramType.MYSQL.name()) || codeProgramType.equals(CodeProgramType.SQLSERVER.name()) || codeProgramType.equals(CodeProgramType.Oracle.name()) || codeProgramType.equals(CodeProgramType.POSTGRESQL.name()) || codeProgramType.equals(CodeProgramType.StarRocks.name()) || codeProgramType.equals(CodeProgramType.DRDS.name()) || codeProgramType.equals(CodeProgramType.Doris.name()) || codeProgramType.equals(CodeProgramType.Mariadb.name()) || codeProgramType.equals(CodeProgramType.Selectdb.name()) || codeProgramType.equals(CodeProgramType.Redshift.name()) || codeProgramType.equals(CodeProgramType.Saphana.name()) || codeProgramType.equals(CodeProgramType.Vertica.name()) || codeProgramType.equals(CodeProgramType.OceanBase.name()) || codeProgramType.equals(CodeProgramType.DB2.name()) || codeProgramType.equals(CodeProgramType.ADB_for_PostgreSQL.name()) || codeProgramType.equals(CodeProgramType.ADB_for_MySQL.name())) {
            tgtworkflowNode.setNodeType(codeProgramType);
        }
        this.supplyBaseMsg(tgtworkflowNode);
        tgtNodes.add(tgtworkflowNode);
        return tgtNodes;
    }

    private String getCodeProgramType(WorkflowNode workflowNode, String dbType) {
        if (DbType.HIVE.name().equalsIgnoreCase(dbType)) {
            return CodeProgramType.EMR_HIVE.name();
        }
        if (DbType.SPARK.name().equalsIgnoreCase(dbType)) {
            return CodeProgramType.EMR_SPARK.name();
        }
        if (DbType.CLICKHOUSE.name().equalsIgnoreCase(dbType)) {
            return CodeProgramType.CLICK_SQL.name();
        }
        if (DbType.ofName((String)dbType) != null) {
            return dbType;
        }
        String defaultNodeTypeIfNotSupport = CodeProgramType.MYSQL.name();
        log.warn("using default node Type {} for node {}", (Object)defaultNodeTypeIfNotSupport, (Object)workflowNode.getNodeName());
        return defaultNodeTypeIfNotSupport;
    }

    private void chooseDataSource(WorkflowNode workflowNode, WorkflowNode tgtworkflowNode, String codeProgramType) {
        try {
            String sqlParamStr = workflowNode.getCustomProperties().getOrDefault("SQL_PARAM", "").toString();
            if (StringUtils.isNotBlank((String)sqlParamStr)) {
                SqlParameters parameter = (SqlParameters)GsonUtils.fromJsonString((String)sqlParamStr, (Type)TypeToken.get(SqlParameters.class).getType());
                if (tgtworkflowNode.getCustomProperties() == null) {
                    tgtworkflowNode.setCustomProperties(new HashMap());
                }
                tgtworkflowNode.getCustomProperties().put("datasource", this.getConnectionName(parameter, codeProgramType, tgtworkflowNode));
            }
        }
        catch (Exception e) {
            log.error("chooseDataSource error {} {}", new Object[]{workflowNode.getWorkflowName(), workflowNode.getNodeName(), e});
        }
    }

    private void getNodeParam(WorkflowNode workflowNode, WorkflowNode tgtworkflowNode) {
        try {
            String sqlParamStr = workflowNode.getCustomProperties().getOrDefault("SQL_PARAM", "").toString();
            if (StringUtils.isNotBlank((String)sqlParamStr)) {
                SqlParameters parameter = (SqlParameters)GsonUtils.fromJsonString((String)sqlParamStr, (Type)TypeToken.get(SqlParameters.class).getType());
                if (parameter.getLocalParams() == null) {
                    parameter.setLocalParams(new ArrayList());
                }
                if (!parameter.getLocalParams().isEmpty()) {
                    parameter.getLocalParams().forEach(localParam -> tgtworkflowNode.getParamMap().put(localParam.getProp(), localParam.getValue()));
                }
            }
        }
        catch (Exception e) {
            log.error("chooseDataSource error {} {}", new Object[]{workflowNode.getWorkflowName(), workflowNode.getNodeName(), e});
        }
    }

    private String getConnectionName(SqlParameters parameter, String codeProgramType, WorkflowNode workflowNode) {
        Map nodeConfMap = this.getNodeConfMap(workflowNode);
        String mappingJson = nodeConfMap.getOrDefault("workflow.converter.connection.mapping", "{}");
        if (mappingJson instanceof JSONObject) {
            JSONObject connectionMapping = (JSONObject)mappingJson;
            if (connectionMapping == null) {
                log.error("parse connection mapping with {} error", (Object)mappingJson);
            } else {
                String connectionName;
                String datasourceId = String.valueOf(parameter.getDatasource());
                String datasourceName = null;
                if (!this.taskContext.getWorkflowProjectPackage().getDatasources().isEmpty()) {
                    for (WorkflowDatasource datasource : this.taskContext.getWorkflowProjectPackage().getDatasources()) {
                        if (!datasourceId.equals(datasource.getDatasourceId())) continue;
                        datasourceName = datasource.getName();
                        break;
                    }
                }
                if (StringUtils.isEmpty((String)(connectionName = connectionMapping.getString(datasourceId)))) {
                    connectionName = connectionMapping.getString(datasourceName);
                }
                log.info("Got connectionName {}", (Object)connectionName);
                return connectionName;
            }
        }
        if (!CodeProgramType.EMR_HIVE.name().equals(codeProgramType) && !CodeProgramType.EMR_SPARK.name().equals(codeProgramType)) {
            List workflowDatasources = this.taskContext.getWorkflowDatasources();
            if (parameter.getDatasource() > 0) {
                String connectionName = CollectionUtils.emptyIfNull((Collection)workflowDatasources).stream().filter(s -> s.getDatasourceId().equalsIgnoreCase(String.valueOf(parameter.getDatasource()))).findFirst().map(WorkflowDatasource::getName).orElse("");
                if (StringUtils.isEmpty((String)connectionName)) {
                    return null;
                }
                return connectionName;
            }
        }
        return null;
    }

    protected String getNodeType(WorkflowNode workflowNode) {
        return CodeProgramType.ODPS_SQL.name();
    }

    private String getDbType(WorkflowNode workflowNode) {
        JSONObject jsonObject;
        String dbType;
        Map nodeConfMap = this.getNodeConfMap(workflowNode);
        String orDefault = ((Map)Optional.ofNullable(nodeConfMap).orElse(new HashMap())).getOrDefault("workflow.converter.dolphinscheduler.sqlNodeTypeMapping", CodeProgramType.SQL_COMPONENT.name());
        if (orDefault instanceof JSONObject && StringUtils.isNotBlank((String)(dbType = (jsonObject = (JSONObject)orDefault).getString(workflowNode.getDbType())))) {
            return dbType;
        }
        return CodeProgramType.MYSQL.name();
    }
}

