/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.converter.dsv3.convert;

import com.aliyun.dataworks.common.spec.domain.dw.codemodel.OdpsSparkCode;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.utils.ArgsUtils;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.model.ProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.model.ResourceInfo;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.spark.SparkParameters;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFileResource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.convert.AbstractNodeConvert;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkNodeConvert
extends AbstractNodeConvert {
    private static final Logger log = LoggerFactory.getLogger(SparkNodeConvert.class);

    public SparkNodeConvert(TaskContext taskContext, Workflow workflow) {
        super(taskContext);
        this.workflow = workflow;
    }

    public List<WorkflowNode> convert(List<WorkflowNode> workflowNodes) {
        if (CollectionUtils.isEmpty(workflowNodes)) {
            log.warn("node convert workflowNodes is null");
            return new ArrayList<WorkflowNode>();
        }
        WorkflowNode workflowNode = workflowNodes.get(0);
        ArrayList<WorkflowNode> tgtNodes = new ArrayList<WorkflowNode>();
        WorkflowNode tgtworkflowNode = (WorkflowNode)BwmJsonUtil.deepCopy((Object)workflowNode, WorkflowNode.class);
        if (Objects.isNull(tgtworkflowNode)) {
            log.error("convert tgt node error, result is null");
            return tgtNodes;
        }
        ExtendSparkParameters parameter = (ExtendSparkParameters)((Object)GsonUtils.fromJsonString((String)workflowNode.getScript(), (Type)TypeToken.get(ExtendSparkParameters.class).getType()));
        String type = this.getNodeType(workflowNode);
        tgtworkflowNode.setNodeType(type);
        tgtworkflowNode.setScript(parameter.getRawScript());
        parameter.setSparkVersion(this.getSparkVersion(workflowNode));
        if (CodeProgramType.EMR_SPARK.equals((Object)CodeProgramType.of((String)type))) {
            List<String> cmd = this.populateSparkOptions(parameter);
            tgtworkflowNode.setScript(String.join((CharSequence)" ", cmd));
        } else if (CodeProgramType.ODPS_SPARK.equals((Object)CodeProgramType.of((String)type))) {
            if (parameter.getProgramType().equals((Object)ProgramType.SQL)) {
                tgtworkflowNode.setNodeType(CodeProgramType.ODPS_SQL.getName());
                tgtworkflowNode.setScript(parameter.getRawScript());
            } else {
                OdpsSparkCode odpsSparkCode = this.populateSparkOdpsCode(parameter);
                tgtworkflowNode.setScript(odpsSparkCode.toString());
            }
        }
        this.supplyBaseMsg(tgtworkflowNode);
        tgtNodes.add(tgtworkflowNode);
        return tgtNodes;
    }

    private List<String> populateSparkOptions(SparkParameters sparkParameters) {
        String yarnQueue;
        String deployMode;
        ArrayList<String> args = new ArrayList<String>();
        ProgramType programType = sparkParameters.getProgramType();
        ResourceInfo mainJar = sparkParameters.getMainJar();
        if (programType != ProgramType.SQL) {
            String resource = mainJar.getResourceName();
            if (StringUtils.isEmpty((CharSequence)resource)) {
                resource = this.getResourceName(mainJar.getId());
            }
            if (resource != null) {
                String[] resources = resource.split("/");
                if (resources.length > 0) {
                    resource = resources[resources.length - 1];
                }
                mainJar.setResourceName(resource);
            } else {
                args.add("spark-submit");
            }
        } else {
            args.add("spark-submit");
        }
        String string = deployMode = StringUtils.isNotEmpty((CharSequence)sparkParameters.getDeployMode()) ? sparkParameters.getDeployMode() : "local";
        if (!"local".equals(deployMode)) {
            args.add("--master");
            String masterUrl = "yarn";
            args.add(masterUrl);
        }
        args.add("--deploy-mode");
        args.add(deployMode);
        String mainClass = sparkParameters.getMainClass();
        if (programType != ProgramType.PYTHON && programType != ProgramType.SQL && StringUtils.isNotEmpty((CharSequence)mainClass)) {
            args.add("--class");
            args.add(mainClass);
        }
        this.populateSparkResourceDefinitions(args, sparkParameters);
        String appName = sparkParameters.getAppName();
        if (StringUtils.isNotEmpty((CharSequence)appName)) {
            args.add("--name");
            args.add(ArgsUtils.escape((String)appName));
        }
        String others = sparkParameters.getOthers();
        if (!"local".equals(deployMode) && (StringUtils.isEmpty((CharSequence)others) || !others.contains("--queue")) && StringUtils.isNotEmpty((CharSequence)(yarnQueue = sparkParameters.getYarnQueue()))) {
            args.add("--queue");
            args.add(yarnQueue);
        }
        if (StringUtils.isNotEmpty((CharSequence)others)) {
            args.add(others);
        }
        if (programType != ProgramType.SQL && mainJar != null) {
            args.add(mainJar.getResourceName());
        }
        String mainArgs = sparkParameters.getMainArgs();
        if (programType != ProgramType.SQL && StringUtils.isNotEmpty((CharSequence)mainArgs)) {
            args.add(mainArgs);
        }
        return args;
    }

    private OdpsSparkCode populateSparkOdpsCode(ExtendSparkParameters parameter) {
        if (parameter == null) {
            return null;
        }
        if (parameter.getProgramType().equals((Object)ProgramType.JAVA)) {
            return this.populateSparkJarOdpsCode(parameter);
        }
        if (parameter.getProgramType().equals((Object)ProgramType.PYTHON)) {
            return this.populateSparkPyOdpsCode(parameter);
        }
        if (parameter.getProgramType().equals((Object)ProgramType.SQL)) {
            return null;
        }
        return null;
    }

    private OdpsSparkCode populateSparkJarOdpsCode(ExtendSparkParameters parameter) {
        OdpsSparkCode odpsSparkCode = new OdpsSparkCode();
        odpsSparkCode.setResourceReferences(odpsSparkCode.getResourceReferences());
        odpsSparkCode.setSparkJson(new OdpsSparkCode.CodeJson());
        ResourceInfo mainJar = parameter.getMainJar();
        if (Objects.isNull(mainJar)) {
            log.warn("not found main jar");
            odpsSparkCode.setSourceCode(parameter.getRawScript());
            return odpsSparkCode;
        }
        String resource = mainJar.getResourceName();
        if (StringUtils.isEmpty((CharSequence)resource)) {
            resource = this.getResourceName(mainJar.getId());
        }
        if (resource != null) {
            String[] resources = resource.split("/");
            if (resources.length > 0) {
                resource = resources[resources.length - 1];
            }
            mainJar.setResourceName(resource);
            if (resource.endsWith(".jar")) {
                odpsSparkCode.getSparkJson().setMainJar(resource);
            } else if (resource.endsWith(".py")) {
                odpsSparkCode.getSparkJson().setMainPy(resource);
            } else {
                odpsSparkCode.getSparkJson().setMainJar(resource);
            }
        }
        String mainClass = parameter.getMainClass();
        odpsSparkCode.getSparkJson().setMainClass(mainClass);
        odpsSparkCode.getSparkJson().setVersion(parameter.getSparkVersion());
        odpsSparkCode.getSparkJson().setLanguage("java");
        String mainArgs = parameter.getMainArgs();
        odpsSparkCode.getSparkJson().setArgs(mainArgs);
        ArrayList<String> confs = new ArrayList<String>();
        this.populateOdpsSparkResourceDefinitions(confs, parameter);
        odpsSparkCode.getSparkJson().setConfigs(confs);
        return odpsSparkCode;
    }

    private OdpsSparkCode populateSparkPyOdpsCode(ExtendSparkParameters parameter) {
        OdpsSparkCode odpsSparkCode = new OdpsSparkCode();
        odpsSparkCode.setResourceReferences(odpsSparkCode.getResourceReferences());
        odpsSparkCode.setSparkJson(new OdpsSparkCode.CodeJson());
        ResourceInfo mainPy = parameter.getMainJar();
        if (Objects.isNull(mainPy)) {
            log.warn("not found main py");
            odpsSparkCode.setSourceCode(parameter.getRawScript());
            return odpsSparkCode;
        }
        String resource = mainPy.getResourceName();
        if (StringUtils.isEmpty((CharSequence)resource)) {
            resource = this.getResourceName(mainPy.getId());
        }
        if (resource != null) {
            String[] resources = resource.split("/");
            if (resources.length > 0) {
                resource = resources[resources.length - 1];
            }
            mainPy.setResourceName(resource);
            odpsSparkCode.getSparkJson().setMainPy(resource);
        }
        odpsSparkCode.getSparkJson().setVersion(parameter.getSparkVersion());
        odpsSparkCode.getSparkJson().setLanguage("python");
        String mainArgs = parameter.getMainArgs();
        odpsSparkCode.getSparkJson().setArgs(mainArgs);
        ArrayList<String> confs = new ArrayList<String>();
        this.populateOdpsSparkResourceDefinitions(confs, parameter);
        odpsSparkCode.getSparkJson().setConfigs(confs);
        return odpsSparkCode;
    }

    private void populateSparkResourceDefinitions(List<String> args, SparkParameters sparkParameters) {
        String executorMemory;
        int executorCores;
        int numExecutors;
        String driverMemory;
        int driverCores = sparkParameters.getDriverCores();
        if (driverCores > 0) {
            args.add(String.format("--conf spark.driver.cores=%d", driverCores));
        }
        if (StringUtils.isNotEmpty((CharSequence)(driverMemory = sparkParameters.getDriverMemory()))) {
            args.add(String.format("--conf spark.driver.memory=%s", driverMemory));
        }
        if ((numExecutors = sparkParameters.getNumExecutors()) > 0) {
            args.add(String.format("--conf spark.executor.instances=%d", numExecutors));
        }
        if ((executorCores = sparkParameters.getExecutorCores()) > 0) {
            args.add(String.format("--conf spark.executor.cores=%d", executorCores));
        }
        if (StringUtils.isNotEmpty((CharSequence)(executorMemory = sparkParameters.getExecutorMemory()))) {
            args.add(String.format("--conf spark.executor.memory=%s", executorMemory));
        }
    }

    private void populateOdpsSparkResourceDefinitions(List<String> args, SparkParameters sparkParameters) {
        String executorMemory;
        int executorCores;
        int numExecutors;
        String driverMemory;
        int driverCores = sparkParameters.getDriverCores();
        if (driverCores > 0) {
            args.add(String.format("spark.driver.cores=%d", driverCores));
        }
        if (StringUtils.isNotEmpty((CharSequence)(driverMemory = sparkParameters.getDriverMemory()))) {
            args.add(String.format("spark.driver.memory=%s", driverMemory));
        }
        if ((numExecutors = sparkParameters.getNumExecutors()) > 0) {
            args.add(String.format("spark.executor.instances=%d", numExecutors));
        }
        if ((executorCores = sparkParameters.getExecutorCores()) > 0) {
            args.add(String.format("spark.executor.cores=%d", executorCores));
        }
        if (StringUtils.isNotEmpty((CharSequence)(executorMemory = sparkParameters.getExecutorMemory()))) {
            args.add(String.format("spark.executor.memory=%s", executorMemory));
        }
    }

    private String getResourceName(Integer id) {
        if (id == null) {
            return null;
        }
        ArrayList allFiles = new ArrayList();
        List projectFiles = this.taskContext.getWorkflowProjectPackage().getFiles();
        List workflowFiles = this.workflow.getFiles();
        if (CollectionUtils.isNotEmpty((Collection)projectFiles)) {
            allFiles.addAll(projectFiles);
        }
        if (CollectionUtils.isNotEmpty((Collection)workflowFiles)) {
            allFiles.addAll(workflowFiles);
        }
        return CollectionUtils.emptyIfNull(allFiles).stream().filter(r -> Long.parseLong(r.getId()) == (long)id.intValue()).findAny().map(WorkflowFileResource::getName).orElseGet(null);
    }

    protected String getNodeType(WorkflowNode workflowNode) {
        return this.getNodeConfMap(workflowNode).getOrDefault("workflow.converter.sparkSubmitAs", CodeProgramType.EMR_SPARK.name());
    }

    private String getSparkVersion(WorkflowNode workflowNode) {
        return this.getNodeConfMap(workflowNode).getOrDefault("workflow.converter.sparkVersion", "3.x");
    }

    private class ExtendSparkParameters
    extends SparkParameters {
        private String sparkVersion;
        private SparkParameters sparkParameters;

        private ExtendSparkParameters() {
        }

        public String getSparkVersion() {
            return this.sparkVersion;
        }

        public SparkParameters getSparkParameters() {
            return this.sparkParameters;
        }

        public void setSparkVersion(String sparkVersion) {
            this.sparkVersion = sparkVersion;
        }

        public void setSparkParameters(SparkParameters sparkParameters) {
            this.sparkParameters = sparkParameters;
        }
    }
}

