/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.converter.dsv3.convert;

import com.aliyun.dataworks.common.spec.domain.dw.types.CalcEngineType;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.common.spec.domain.dw.types.LabelType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.python.PythonParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.utils.DataStudioCodeUtils;
import com.aliyun.dataworks.migrationx.transformer.dataworks.transformer.DataWorksTransformerConfig;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.api.exception.BwmErrorCode;
import com.aliyun.migration.api.exception.BwmException;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowFileResource;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.convert.AbstractNodeConvert;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.google.common.base.Joiner;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PythonNodeConvert
extends AbstractNodeConvert {
    private static final Logger log = LoggerFactory.getLogger(PythonNodeConvert.class);

    public PythonNodeConvert(TaskContext taskContext, Workflow workflow) {
        super(taskContext);
        this.workflow = workflow;
    }

    public List<WorkflowNode> convert(List<WorkflowNode> workflowNodes) {
        if (CollectionUtils.isEmpty(workflowNodes)) {
            log.warn("node convert workflowNodes is null");
            return new ArrayList<WorkflowNode>();
        }
        WorkflowNode workflowNode = workflowNodes.get(0);
        ArrayList<WorkflowNode> tgtNodes = new ArrayList<WorkflowNode>();
        WorkflowNode tgtworkflowNode = (WorkflowNode)BwmJsonUtil.deepCopy((Object)workflowNode, WorkflowNode.class);
        if (Objects.isNull(tgtworkflowNode)) {
            log.error("convert tgt node error, result is null");
            return tgtNodes;
        }
        String nodeType = this.getNodeType(workflowNode);
        tgtworkflowNode.setNodeType(nodeType);
        PythonParameters parameter = (PythonParameters)GsonUtils.fromJsonString((String)workflowNode.getScript(), (Type)TypeToken.get(PythonParameters.class).getType());
        String usingCmd = this.getNodeConfMap(workflowNode).getOrDefault("workflow.converter.dolphinscheduler.python.code.block", "false");
        if (Boolean.parseBoolean(usingCmd)) {
            String cmd = "python -c \"" + parameter.getRawScript() + "\"";
            tgtworkflowNode.setScript(cmd);
        } else if (CodeProgramType.ODPS_PYTHON.equals((Object)CodeProgramType.of((String)nodeType)) || CodeProgramType.PYODPS.equals((Object)CodeProgramType.of((String)nodeType)) || CodeProgramType.PYODPS3.equals((Object)CodeProgramType.of((String)nodeType)) || CodeProgramType.PYTHON.equals((Object)CodeProgramType.of((String)nodeType))) {
            tgtworkflowNode.setScript(parameter.getRawScript());
        } else {
            WorkflowFileResource fileResource = new WorkflowFileResource();
            fileResource.setName(Joiner.on((String)"_").join((Object)this.workflow.getWorkflowName(), (Object)workflowNode.getNodeName(), new Object[0]) + ".py");
            List allFiles = this.getAllFileResources();
            List resources = ListUtils.emptyIfNull((List)parameter.getResourceList()).stream().map(resource -> {
                CollectionUtils.emptyIfNull((Collection)allFiles).stream().filter(r -> r.getName() == resource.getResourceName()).findAny().ifPresent(r -> resource.setResourceName(r.getName()));
                return resource.getResourceName();
            }).filter(name -> StringUtils.isNotEmpty((CharSequence)name)).distinct().collect(Collectors.toList());
            this.workflow.getFiles().add(fileResource);
            resources.add(fileResource.getName());
            tgtworkflowNode.setScript(Joiner.on((String)"\n").join((Object)DataStudioCodeUtils.addResourceReference((CodeProgramType)CodeProgramType.of((String)tgtworkflowNode.getNodeType()), (String)"", resources), (Object)("python ./" + fileResource.getName()), new Object[0]));
            String engineType = this.getNodeConfMap(workflowNode).getOrDefault("workflow.converter.target.engine.type", "");
            if (CodeProgramType.EMR_SHELL.equals((Object)CodeProgramType.of((String)nodeType)) && StringUtils.equalsIgnoreCase((CharSequence)CalcEngineType.EMR.name(), (CharSequence)engineType)) {
                fileResource.setFileType(CodeProgramType.EMR_FILE.name());
                tgtworkflowNode.setScript(PythonNodeConvert.wfToEmrCode((WorkflowNode)tgtworkflowNode));
                paths = new ArrayList();
                config = DataWorksTransformerConfig.getConfig();
                if (config != null) {
                    paths.add(CalcEngineType.EMR.getDisplayName(config.getLocale()));
                    paths.add(LabelType.RESOURCE.getDisplayName(config.getLocale()));
                } else {
                    paths.add(CalcEngineType.EMR.getDisplayName(Locale.SIMPLIFIED_CHINESE));
                    paths.add(LabelType.RESOURCE.getDisplayName(Locale.SIMPLIFIED_CHINESE));
                }
                fileResource.setFolder(Joiner.on((String)File.separator).join(paths));
            } else if (StringUtils.equalsIgnoreCase((CharSequence)CalcEngineType.HADOOP_CDH.name(), (CharSequence)engineType)) {
                fileResource.setFileType(CodeProgramType.CDH_FILE.name());
                paths = new ArrayList<String>();
                config = DataWorksTransformerConfig.getConfig();
                if (config != null) {
                    paths.add(CalcEngineType.HADOOP_CDH.getDisplayName(config.getLocale()));
                    paths.add(LabelType.RESOURCE.getDisplayName(config.getLocale()));
                } else {
                    paths.add(CalcEngineType.HADOOP_CDH.getDisplayName(Locale.SIMPLIFIED_CHINESE));
                    paths.add(LabelType.RESOURCE.getDisplayName(Locale.SIMPLIFIED_CHINESE));
                }
                fileResource.setFolder(Joiner.on((String)File.separator).join(paths));
            } else {
                fileResource.setFileType(CodeProgramType.of((String)nodeType).getName());
                paths = new ArrayList();
                config = DataWorksTransformerConfig.getConfig();
                if (config != null) {
                    paths.add(CalcEngineType.ODPS.getDisplayName(config.getLocale()));
                    paths.add(LabelType.RESOURCE.getDisplayName(config.getLocale()));
                } else {
                    paths.add(CalcEngineType.ODPS.getDisplayName(Locale.SIMPLIFIED_CHINESE));
                    paths.add(LabelType.RESOURCE.getDisplayName(Locale.SIMPLIFIED_CHINESE));
                }
                fileResource.setFolder(Joiner.on((String)File.separator).join(paths));
            }
            File tmpFIle = new File(FileUtils.getTempDirectory(), fileResource.getName());
            try {
                FileUtils.writeStringToFile((File)tmpFIle, (String)parameter.getRawScript(), (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                log.error("write file error ", (Throwable)e);
                throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.NODE_CONVERT_FAILED);
            }
            fileResource.setPath(tmpFIle.getAbsolutePath());
        }
        this.supplyBaseMsg(tgtworkflowNode);
        tgtNodes.add(tgtworkflowNode);
        return tgtNodes;
    }

    protected String getNodeType(WorkflowNode workflowNode) {
        return this.getNodeConfMap(workflowNode).getOrDefault("workflow.converter.pyNodeType", CodeProgramType.PYODPS3.name());
    }
}

