/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.converter.dsv3.convert;

import com.alibaba.fastjson2.JSONObject;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.procedure.ProcedureParameters;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.convert.AbstractNodeConvert;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcedureNodeConvert
extends AbstractNodeConvert {
    private static final Logger log = LoggerFactory.getLogger(ProcedureNodeConvert.class);

    public ProcedureNodeConvert(TaskContext taskContext, Workflow workflow) {
        super(taskContext);
        this.workflow = workflow;
    }

    public List<WorkflowNode> convert(List<WorkflowNode> workflowNodes) {
        if (CollectionUtils.isEmpty(workflowNodes)) {
            log.warn("node convert workflowNodes is null");
            return new ArrayList<WorkflowNode>();
        }
        WorkflowNode workflowNode = workflowNodes.get(0);
        ArrayList<WorkflowNode> tgtNodes = new ArrayList<WorkflowNode>();
        WorkflowNode tgtworkflowNode = (WorkflowNode)BwmJsonUtil.deepCopy((Object)workflowNode, WorkflowNode.class);
        ProcedureParameters parameter = (ProcedureParameters)GsonUtils.fromJsonString((String)workflowNode.getScript(), (Type)TypeToken.get(ProcedureParameters.class).getType());
        tgtworkflowNode.setNodeType(this.getNodeType(workflowNode));
        tgtworkflowNode.setDbType(this.getDbType(workflowNode));
        tgtworkflowNode.setDatasourceId(String.valueOf(parameter.getDatasource()));
        tgtworkflowNode.setScript(parameter.getMethod());
        this.supplyBaseMsg(tgtworkflowNode);
        tgtNodes.add(tgtworkflowNode);
        return tgtNodes;
    }

    protected String getNodeType(WorkflowNode workflowNode) {
        return CodeProgramType.SQL_COMPONENT.name();
    }

    private String getDbType(WorkflowNode workflowNode) {
        JSONObject jsonObject;
        String dbType;
        Map nodeConfMap = this.getNodeConfMap(workflowNode);
        String orDefault = ((Map)Optional.ofNullable(nodeConfMap).orElse(new HashMap())).getOrDefault("workflow.converter.dolphinscheduler.sqlNodeTypeMapping", CodeProgramType.SQL_COMPONENT.name());
        if (orDefault instanceof JSONObject && StringUtils.isNotBlank((String)(dbType = (jsonObject = (JSONObject)orDefault).getString(workflowNode.getDbType().toUpperCase(Locale.ROOT))))) {
            return dbType;
        }
        return CodeProgramType.MYSQL.name();
    }
}

