/*
 * Decompiled with CFR 0.152.
 */
package com.workflow.migration.transform.dw.converter.dsv3.convert;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.aliyun.dataworks.common.spec.domain.dw.types.CodeProgramType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.http.HttpParameters;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.http.HttpParametersType;
import com.aliyun.dataworks.migrationx.domain.dataworks.dolphinscheduler.v3.task.http.HttpProperty;
import com.aliyun.migration.api.context.TaskContext;
import com.aliyun.migration.api.exception.BwmErrorCode;
import com.aliyun.migration.api.exception.BwmException;
import com.aliyun.migration.api.exception.BwmServiceErrorCode;
import com.aliyun.migration.teleport.common.element.meta.workflow.Workflow;
import com.aliyun.migration.teleport.common.element.meta.workflow.WorkflowNode;
import com.aliyun.migration.workflow.migration.common.convert.AbstractNodeConvert;
import com.aliyun.migration.workflow.migration.common.utils.BwmJsonUtil;
import com.aliyun.migrationx.common.utils.GsonUtils;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpNodeConvert
extends AbstractNodeConvert {
    private static final Logger log = LoggerFactory.getLogger(HttpNodeConvert.class);

    public HttpNodeConvert(TaskContext taskContext, Workflow workflow) {
        super(taskContext);
        this.workflow = workflow;
    }

    public List<WorkflowNode> convert(List<WorkflowNode> workflowNodes) {
        if (CollectionUtils.isEmpty(workflowNodes)) {
            log.warn("node convert workflowNodes is null");
            return new ArrayList<WorkflowNode>();
        }
        WorkflowNode workflowNode = workflowNodes.get(0);
        ArrayList<WorkflowNode> tgtNodes = new ArrayList<WorkflowNode>();
        WorkflowNode tgtworkflowNode = (WorkflowNode)BwmJsonUtil.deepCopy((Object)workflowNode, WorkflowNode.class);
        if (Objects.isNull(tgtworkflowNode)) {
            log.error("deepcopy failed, tgtworkflownode is null");
            throw BwmException.asBwmException((BwmErrorCode)BwmServiceErrorCode.PACKAGE_CONVERT_FAILED, (String)"copy workflownode failed");
        }
        HttpParameters parameter = (HttpParameters)GsonUtils.fromJsonString((String)workflowNode.getScript(), (Type)TypeToken.get(HttpParameters.class).getType());
        Object getScript = "curl";
        if (parameter.getHttpParams() != null && parameter.getHttpParams().size() > 0) {
            for (Object httpParam : parameter.getHttpParams()) {
                if (!httpParam.getHttpParametersType().equals((Object)HttpParametersType.HEADERS)) continue;
                getScript = (String)getScript + " -H \"" + StringEscapeUtils.escapeJava((String)(httpParam.getProp() + ":" + httpParam.getValue())) + "\"";
            }
        }
        JSONObject body = new JSONObject();
        if (parameter.getHttpParams() != null && parameter.getHttpParams().size() > 0) {
            for (HttpProperty httpParam : parameter.getHttpParams()) {
                if (!httpParam.getHttpParametersType().equals((Object)HttpParametersType.BODY)) continue;
                body.put((Object)httpParam.getProp(), (Object)httpParam.getValue());
            }
        }
        if (body.size() > 0) {
            getScript = (String)getScript + " -d \"" + StringEscapeUtils.escapeJava((String)body.toJSONString(new JSONWriter.Feature[0])) + "\"";
        }
        getScript = (String)getScript + "-X " + parameter.getHttpMethod().name() + " " + parameter.getUrl();
        String queryParam = null;
        if (parameter.getHttpParams() != null && parameter.getHttpParams().size() > 0) {
            for (HttpProperty httpParam : parameter.getHttpParams()) {
                if (!httpParam.getHttpParametersType().equals((Object)HttpParametersType.PARAMETER)) continue;
                if (queryParam == null) {
                    queryParam = "?" + StringEscapeUtils.escapeHtml((String)(httpParam.getProp() + "=" + httpParam.getValue()));
                    continue;
                }
                queryParam = queryParam + "&" + StringEscapeUtils.escapeHtml((String)(httpParam.getProp() + "=" + httpParam.getValue()));
            }
        }
        if (queryParam != null) {
            getScript = (String)getScript + queryParam;
        }
        tgtworkflowNode.setScript((String)getScript);
        tgtworkflowNode.setNodeType(this.getNodeType(workflowNode));
        this.supplyBaseMsg(tgtworkflowNode);
        tgtNodes.add(tgtworkflowNode);
        return tgtNodes;
    }

    protected String getNodeType(WorkflowNode workflowNode) {
        return CodeProgramType.DIDE_SHELL.getName();
    }
}

