/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migrationx.common.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GsonUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(GsonUtils.class);
    public static String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static Gson gson;
    public static Gson gsonNoPrettyPrint;
    public static Gson defaultGson;

    public static synchronized void initGson() {
        gson = new GsonBuilder().setDateFormat(DATE_FORMAT).setPrettyPrinting().create();
        gsonNoPrettyPrint = new GsonBuilder().setDateFormat(DATE_FORMAT).create();
        defaultGson = new GsonBuilder().setDateFormat(DATE_FORMAT).disableHtmlEscaping().create();
    }

    public static String toJsonString(Object object) {
        if (object != null) {
            return gson.toJson(object);
        }
        return null;
    }

    public static <T> T fromJsonString(String jsonString, Type type) {
        if (StringUtils.isBlank((CharSequence)jsonString)) {
            return null;
        }
        try {
            return (T)gson.fromJson(jsonString, type);
        }
        catch (Throwable e) {
            LOGGER.error("parse json string: {}, exception: ", (Object)jsonString, (Object)e);
            throw e;
        }
    }

    public static <T> T fromJson(JsonObject json, Type type) {
        if (json == null) {
            return null;
        }
        try {
            return (T)gson.fromJson((JsonElement)json, type);
        }
        catch (Throwable e) {
            LOGGER.error("parse json string: {}, exception: ", (Object)json, (Object)e);
            throw e;
        }
    }

    public static String toEnumString(Enum enumObj) {
        if (enumObj != null) {
            return enumObj.name();
        }
        return null;
    }

    public static JsonObject toJsonObject(Object object) {
        if (object == null) {
            return null;
        }
        String jsonString = GsonUtils.toJsonString(object);
        return (JsonObject)gson.fromJson(jsonString, JsonObject.class);
    }

    static {
        GsonUtils.initGson();
    }

    public static class LocaleAdapter
    implements JsonSerializer<Locale>,
    JsonDeserializer<Locale> {
        public Locale deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            if (jsonElement.isJsonPrimitive()) {
                String locale = jsonElement.getAsString();
                return Arrays.stream(Locale.getAvailableLocales()).filter(lc -> StringUtils.equalsIgnoreCase((CharSequence)locale, (CharSequence)lc.toString())).findAny().orElse(null);
            }
            throw new RuntimeException("invalid locale type: " + type + ", json: {}" + jsonElement);
        }

        public JsonElement serialize(Locale locale, Type type, JsonSerializationContext jsonSerializationContext) {
            return Optional.ofNullable(locale).map(Locale::toString).map(l -> jsonSerializationContext.serialize(l, String.class)).orElse(jsonSerializationContext.serialize(null));
        }
    }
}

