/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migrationx.common.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateUtils {
    private static final Logger logger = LoggerFactory.getLogger(DateUtils.class);

    public static Date getNormalizedDate() {
        return DateUtils.getDate(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, 0, 0, 0, 0);
    }

    public static Date getNormalizedDate(int year, int month, int day) {
        return DateUtils.getDate(year, month, day, 0, 0, 0, 0);
    }

    private static Date getDate(int year, int month, int day, int hour, int minute, int second, int millisecond) {
        GregorianCalendar gc = (GregorianCalendar)GregorianCalendar.getInstance();
        if (year != Integer.MIN_VALUE) {
            gc.set(1, year);
        }
        if (month != Integer.MIN_VALUE) {
            gc.set(2, month - 1);
        }
        if (day != Integer.MIN_VALUE) {
            gc.set(5, day);
        }
        if (hour != Integer.MIN_VALUE) {
            gc.set(11, hour);
        }
        if (minute != Integer.MIN_VALUE) {
            gc.set(12, minute);
        }
        if (second != Integer.MIN_VALUE) {
            gc.set(13, second);
        }
        if (millisecond != Integer.MIN_VALUE) {
            gc.set(14, millisecond);
        }
        return gc.getTime();
    }

    public static Date getCurrentDay() {
        GregorianCalendar gc = (GregorianCalendar)GregorianCalendar.getInstance();
        gc.set(11, 0);
        gc.set(12, 0);
        gc.set(13, 0);
        gc.set(14, 0);
        return gc.getTime();
    }

    public static Date getCurrentTime() {
        GregorianCalendar gc = (GregorianCalendar)GregorianCalendar.getInstance();
        return gc.getTime();
    }

    public static Date getCurrentDateTime(String pattern) {
        try {
            return DateUtils.convertStringTODate(DateUtils.getCurrentDateString(pattern), pattern);
        }
        catch (ParseException var2) {
            var2.printStackTrace();
            return Calendar.getInstance().getTime();
        }
    }

    public static Date convertStringTODate(String dateStr, String pattern) throws ParseException {
        if (StringUtils.isBlank((CharSequence)dateStr)) {
            return null;
        }
        SimpleDateFormat sf = new SimpleDateFormat(pattern);
        return sf.parse(dateStr);
    }

    public static String getCurrentDateString(String pattern) {
        return DateUtils.convertDateToString(DateUtils.getCurrentTime(), pattern);
    }

    public static Date getAfterDate(Date date) {
        return new Date(date.getTime() + 86400000L);
    }

    public static Date convertLongToDate(long timestamp) {
        GregorianCalendar gc = (GregorianCalendar)GregorianCalendar.getInstance();
        gc.setTimeInMillis(timestamp);
        return gc.getTime();
    }

    public static long convertDateToLong(Date date) {
        GregorianCalendar gc = (GregorianCalendar)GregorianCalendar.getInstance();
        gc.setTime(date);
        return gc.getTimeInMillis();
    }

    public static Date convertStringToDate(String dateStr) {
        return DateUtils.convertStringToDate(dateStr, "yyyy-MM-dd HH:mm:ss");
    }

    public static Date convertStringToDate(String dateStr, String pattern) {
        if (StringUtils.isBlank((CharSequence)dateStr)) {
            return null;
        }
        try {
            SimpleDateFormat sf = new SimpleDateFormat(pattern);
            return sf.parse(dateStr);
        }
        catch (ParseException var3) {
            return null;
        }
    }

    public static String convertDateToString(Date date) {
        return DateUtils.convertDateToString(date, "yyyy-MM-dd HH:mm:ss");
    }

    public static String convertDateToString(Date date, String pattern) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat sf = new SimpleDateFormat(pattern);
        sf.setLenient(false);
        return sf.format(date);
    }

    public static Date getTime() {
        Calendar cal = Calendar.getInstance();
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date parse(String date, String format) {
        try {
            LocalDateTime ldt = LocalDateTime.parse(date, DateTimeFormatter.ofPattern(format));
            return DateUtils.localDateTime2Date(ldt);
        }
        catch (Exception e) {
            logger.error("error while parse date:" + date, (Throwable)e);
            return null;
        }
    }

    private static Date localDateTime2Date(LocalDateTime localDateTime) {
        Instant instant = localDateTime.atZone(ZoneId.systemDefault()).toInstant();
        return Date.from(instant);
    }

    public static String format(Date date, String format) {
        return DateUtils.format(DateUtils.date2LocalDateTime(date), format);
    }

    public static String format(LocalDateTime localDateTime, String format) {
        return localDateTime.format(DateTimeFormatter.ofPattern(format));
    }

    private static LocalDateTime date2LocalDateTime(Date date) {
        return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
    }

    public static Date getFirstDayOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(5, 1);
        return cal.getTime();
    }

    public static Date addDays(Date date, int amount) {
        return DateUtils.add(date, 5, amount);
    }

    public static Date addMinutes(Date date, int amount) {
        return DateUtils.add(date, 12, amount);
    }

    public static Date add(Date date, int calendarField, int amount) {
        if (date == null) {
            throw new IllegalArgumentException("The date must not be null");
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(calendarField, amount);
        return c.getTime();
    }

    public static Date getLastDayOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(2, 1);
        cal.set(5, 1);
        cal.add(5, -1);
        return cal.getTime();
    }

    public static Date getMonday(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.setFirstDayOfWeek(2);
        cal.set(7, 2);
        return cal.getTime();
    }

    public static Date getSunday(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.setFirstDayOfWeek(2);
        cal.set(7, 1);
        return cal.getTime();
    }

    public static Date addMonths(Date date, int amount) {
        return DateUtils.add(date, 2, amount);
    }
}

