/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migrationx.common.exception;

import com.aliyun.migrationx.common.exception.BaseException;
import com.aliyun.migrationx.common.exception.ErrorCode;
import com.aliyun.migrationx.common.utils.IntlUtils;
import com.google.common.base.Joiner;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BizException
extends BaseException {
    private static final Logger log = LoggerFactory.getLogger(BizException.class);

    public BizException(ErrorCode errCode, Object ... errMessages) {
        super(errCode, errCode.getMessage());
        this.setMessage(this.formatMessage(errCode, errMessages));
    }

    public BizException(ErrorCode errorCode, Throwable e, Object ... errMessages) {
        super(errorCode, errorCode.getMessage(), e);
        this.setMessage(this.formatMessage(errorCode, errMessages));
    }

    private String formatMessage(ErrorCode error, Object ... infos) {
        String errorMessage = error.getMessage();
        try {
            errorMessage = error.getMessage();
            HashMap<String, String> params = new HashMap<String, String>();
            int index = 0;
            for (Object info : infos) {
                params.put(String.valueOf(index++), String.valueOf(info));
            }
            return IntlUtils.get(error.name(), params).d(MessageFormat.format(errorMessage, Arrays.stream(infos).map(String::valueOf).toArray()));
        }
        catch (Exception ex) {
            log.warn("format message code: {}, name: {}, exception: ", new Object[]{error.name(), errorMessage, ex});
            return Joiner.on((String)"\n").join((Iterable)Stream.of(infos).filter(Objects::nonNull).map(String::valueOf).collect(Collectors.toList()));
        }
    }

    public static BizException of(ErrorCode errorCode) {
        return new BizException(errorCode, new Object[0]);
    }

    public static BizException of(ErrorCode errorCode, Throwable e) {
        return new BizException(errorCode, e, new Object[0]);
    }

    public BizException with(Object ... info) {
        this.setMessage(this.formatMessage(this.getErrCode(), info));
        return this;
    }
}

