/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.rapt.commons.circuitbreaker.breaker;

import com.aliyun.rapt.commons.circuitbreaker.CircuitBreakEventListener;
import com.aliyun.rapt.commons.circuitbreaker.CircuitBreaker;
import com.aliyun.rapt.commons.logger.SecurityLogManager;
import com.aliyun.security.shade.org.apache.logging.log4j.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class CompositeCircuitBreaker
implements CircuitBreaker<List> {
    private static final Logger logger = SecurityLogManager.getLogger(CompositeCircuitBreaker.class);
    private final List<CircuitBreaker<?>> circuitBreakers;
    private final AtomicBoolean globalState = new AtomicBoolean(true);
    private CircuitBreakEventListener eventListener;
    private final CircuitBreakEventListener statusManager = new CircuitBreakEventListener(){

        @Override
        public void statusChanged(boolean status) {
            CompositeCircuitBreaker.this.refreshState();
        }
    };

    public CompositeCircuitBreaker() {
        this.circuitBreakers = new ArrayList();
    }

    public void refreshState() {
        boolean result = true;
        for (CircuitBreaker<?> circuitBreaker : this.circuitBreakers) {
            if (circuitBreaker.checkState()) continue;
            result = false;
            break;
        }
        if (this.globalState.compareAndSet(!result, result)) {
            this.notifyStateChange();
        }
    }

    private void notifyStateChange() {
        if (this.eventListener != null) {
            this.eventListener.statusChanged(this.globalState.get());
        }
    }

    public void registerCircuitBreaker(CircuitBreaker circuitBreaker) {
        circuitBreaker.setEventListener(this.statusManager);
        this.circuitBreakers.add(circuitBreaker);
        this.refreshState();
    }

    @Override
    public boolean isOpen() {
        return !this.globalState.get();
    }

    @Override
    public boolean isClosed() {
        return this.globalState.get();
    }

    @Override
    public boolean checkState() {
        return this.globalState.get();
    }

    @Override
    public void close() {
        for (CircuitBreaker<?> circuitBreaker : this.circuitBreakers) {
            circuitBreaker.close();
        }
        if (this.globalState.compareAndSet(false, true)) {
            this.notifyStateChange();
        }
    }

    @Override
    public void open() {
        for (CircuitBreaker<?> circuitBreaker : this.circuitBreakers) {
            circuitBreaker.open();
        }
        if (this.globalState.compareAndSet(true, false)) {
            this.notifyStateChange();
        }
    }

    @Override
    public boolean incrementAndCheckState(List increments) {
        for (CircuitBreaker<?> circuitBreaker : this.circuitBreakers) {
            for (Object increment : increments) {
                if (!circuitBreaker.getValueClass().isInstance(increment)) continue;
                circuitBreaker.incrementAndCheckState(increment);
            }
        }
        return this.globalState.get();
    }

    @Override
    public Class getValueClass() {
        return Object.class;
    }

    public CompositeCircuitBreaker clone() {
        CompositeCircuitBreaker clone = new CompositeCircuitBreaker();
        for (CircuitBreaker<?> circuitBreaker : this.circuitBreakers) {
            clone.registerCircuitBreaker(circuitBreaker);
        }
        return clone;
    }

    @Override
    public void setEventListener(CircuitBreakEventListener circuitBreakEventListener) {
        this.eventListener = circuitBreakEventListener;
    }

    @Override
    public void shutdown() {
        for (CircuitBreaker<?> circuitBreaker : this.circuitBreakers) {
            circuitBreaker.shutdown();
        }
    }
}

