/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataworks.migrationx.domain.dataworks.caiyunjian;

import com.aliyun.dataworks.migrationx.domain.dataworks.caiyunjian.DgDatasourceType;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.connection.AbstractConnection;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.connection.FtpConnection;
import com.aliyun.dataworks.migrationx.domain.dataworks.objects.entity.connection.JdbcConnection;
import org.apache.commons.lang3.StringUtils;

public class DgDatasource {
    private Long id;
    private String name;
    private String type;
    private String rootPath;
    private String host;
    private String port;
    private String username;
    private String password;
    private String database;

    public AbstractConnection toConnection() {
        AbstractConnection connection;
        if (StringUtils.isBlank((CharSequence)this.type)) {
            return new AbstractConnection();
        }
        DgDatasourceType dgDatasourceType = DgDatasourceType.getDgDatasourceType(this.type);
        if (dgDatasourceType == null) {
            return new AbstractConnection();
        }
        switch (dgDatasourceType) {
            case ftp: 
            case sftp: {
                connection = new FtpConnection().setHost(this.host).setPassword(this.password).setPort(this.port).setProtocol(this.type).setUsername(this.username).setRootPath(this.rootPath);
                break;
            }
            case mysql: 
            case oceanbase: {
                connection = new JdbcConnection().setJdbcUrl("jdbc:" + this.type + "://" + this.host + ":" + this.port + "/" + (String)StringUtils.defaultIfBlank((CharSequence)this.database, (CharSequence)this.name)).setUsername(this.username).setPassword(this.password);
                break;
            }
            default: {
                connection = new AbstractConnection();
            }
        }
        connection.setConfigType(Integer.valueOf(1));
        connection.setTag("public");
        return connection;
    }

    public String toString() {
        return "DgDatasource(id=" + this.getId() + ", name=" + this.getName() + ", type=" + this.getType() + ", rootPath=" + this.getRootPath() + ", host=" + this.getHost() + ", port=" + this.getPort() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", database=" + this.getDatabase() + ")";
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDatabase() {
        return this.database;
    }

    public DgDatasource setId(Long id) {
        this.id = id;
        return this;
    }

    public DgDatasource setName(String name) {
        this.name = name;
        return this;
    }

    public DgDatasource setType(String type) {
        this.type = type;
        return this;
    }

    public DgDatasource setRootPath(String rootPath) {
        this.rootPath = rootPath;
        return this;
    }

    public DgDatasource setHost(String host) {
        this.host = host;
        return this;
    }

    public DgDatasource setPort(String port) {
        this.port = port;
        return this;
    }

    public DgDatasource setUsername(String username) {
        this.username = username;
        return this;
    }

    public DgDatasource setPassword(String password) {
        this.password = password;
        return this;
    }

    public DgDatasource setDatabase(String database) {
        this.database = database;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DgDatasource)) {
            return false;
        }
        DgDatasource other = (DgDatasource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$rootPath = this.getRootPath();
        String other$rootPath = other.getRootPath();
        if (this$rootPath == null ? other$rootPath != null : !this$rootPath.equals(other$rootPath)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$port = this.getPort();
        String other$port = other.getPort();
        if (this$port == null ? other$port != null : !this$port.equals(other$port)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$database = this.getDatabase();
        String other$database = other.getDatabase();
        return !(this$database == null ? other$database != null : !this$database.equals(other$database));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DgDatasource;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $rootPath = this.getRootPath();
        result = result * 59 + ($rootPath == null ? 43 : $rootPath.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : $port.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $database = this.getDatabase();
        result = result * 59 + ($database == null ? 43 : $database.hashCode());
        return result;
    }
}

