/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.client.event.jms;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import org.apache.oozie.AppType;
import org.apache.oozie.client.event.Event;
import org.apache.oozie.client.event.message.CoordinatorActionMessage;
import org.apache.oozie.client.event.message.EventMessage;
import org.apache.oozie.client.event.message.SLAMessage;
import org.apache.oozie.client.event.message.WorkflowJobMessage;

public abstract class MessageDeserializer {
    public <T extends EventMessage> T getEventMessage(Message message) throws JMSException {
        EventMessage eventMsg;
        block7: {
            String messageBody;
            String msgType;
            TextMessage textMessage;
            block6: {
                textMessage = (TextMessage)message;
                String appTypeString = textMessage.getStringProperty("appType");
                msgType = textMessage.getStringProperty("msgType");
                messageBody = textMessage.getText();
                eventMsg = null;
                if (appTypeString == null || appTypeString.isEmpty() || messageBody == null || messageBody.isEmpty()) {
                    throw new IllegalArgumentException("Could not extract OozieEventMessage. AppType and/or MessageBody is null/empty.Apptype is " + appTypeString + " MessageBody is " + messageBody);
                }
                if (Event.MessageType.valueOf(msgType) != Event.MessageType.JOB) break block6;
                switch (AppType.valueOf(appTypeString)) {
                    case WORKFLOW_JOB: {
                        WorkflowJobMessage wfJobMsg = this.getDeserializedObject(messageBody, WorkflowJobMessage.class);
                        wfJobMsg.setProperties((Message)textMessage);
                        eventMsg = wfJobMsg;
                        break block7;
                    }
                    case COORDINATOR_ACTION: {
                        CoordinatorActionMessage caActionMsg = this.getDeserializedObject(messageBody, CoordinatorActionMessage.class);
                        caActionMsg.setProperties((Message)textMessage);
                        eventMsg = caActionMsg;
                        break block7;
                    }
                    default: {
                        throw new UnsupportedOperationException("Conversion of " + appTypeString + " to Event message is not supported");
                    }
                }
            }
            if (Event.MessageType.valueOf(msgType) == Event.MessageType.SLA) {
                SLAMessage SLAMsg = this.getDeserializedObject(messageBody, SLAMessage.class);
                SLAMsg.setProperties((Message)textMessage);
                eventMsg = SLAMsg;
            }
        }
        return (T)eventMsg;
    }

    protected abstract <T> T getDeserializedObject(String var1, Class<T> var2);
}

