/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.transform.di.sqoop;

import com.alibaba.fastjson2.JSONObject;
import com.aliyun.migration.workflow.migration.common.transform.di.domain.DiDatasourceMappingConfig;
import com.aliyun.migration.workflow.migration.common.transform.di.module.AbstractDIScriptConverter;
import com.aliyun.migration.workflow.migration.common.transform.di.sqoop.ReaderConvertFactory;
import com.aliyun.migration.workflow.migration.common.transform.di.sqoop.WriterConvertFactory;
import com.aliyun.migration.workflow.migration.common.transform.di.sqoop.utils.SqoopCommandUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqoopScriptConverter
extends AbstractDIScriptConverter {
    private static final Logger log = LoggerFactory.getLogger(SqoopScriptConverter.class);

    public SqoopScriptConverter() {
        super(new ReaderConvertFactory(), new WriterConvertFactory());
    }

    @Override
    public JSONObject getRawScriptJson(String rawScript) {
        JSONObject rawScriptJson = new JSONObject();
        Boolean isImport = SqoopCommandUtils.isImport(rawScript);
        if (isImport == null) {
            return null;
        }
        rawScriptJson.put((Object)"isImport", (Object)isImport);
        Map<String, String> args = SqoopCommandUtils.getRawArgs(rawScript);
        if (args == null || args.isEmpty()) {
            return null;
        }
        args.forEach((k, v) -> rawScriptJson.put(k, v));
        return rawScriptJson;
    }

    @Override
    public String getSourceDatasourceName(JSONObject rawScriptJson) {
        if (rawScriptJson.getBoolean("isImport").booleanValue()) {
            if (rawScriptJson.containsKey("connect")) {
                return SqoopCommandUtils.getDatabaseFromUrl(rawScriptJson.getString("connect"));
            }
        } else {
            if (rawScriptJson.containsKey("hcatalog-database")) {
                return rawScriptJson.getString("hcatalog-database");
            }
            if (rawScriptJson.containsKey("export-dir")) {
                return rawScriptJson.getString("export-dir");
            }
            if (rawScriptJson.containsKey("hive-database")) {
                return rawScriptJson.getString("hive-database");
            }
        }
        return null;
    }

    @Override
    public String getSinkDatasourceName(JSONObject rawScriptJson) {
        if (rawScriptJson.getBoolean("isImport").booleanValue()) {
            if (rawScriptJson.containsKey("hcatalog-database")) {
                return rawScriptJson.getString("hcatalog-database");
            }
            if (rawScriptJson.containsKey("target-dir")) {
                return rawScriptJson.getString("target-dir");
            }
            if (rawScriptJson.containsKey("hive-database")) {
                return rawScriptJson.getString("hive-database");
            }
        } else if (rawScriptJson.containsKey("connect")) {
            return SqoopCommandUtils.getDatabaseFromUrl(rawScriptJson.getString("connect"));
        }
        return null;
    }

    @Override
    public DiDatasourceMappingConfig.MigrationDatasourceConnectionMapping getSourceConnectionMapping(JSONObject rawScriptJson) {
        DiDatasourceMappingConfig.MigrationDatasourceConnectionMapping connectionMapping = new DiDatasourceMappingConfig.MigrationDatasourceConnectionMapping();
        if (rawScriptJson.getBoolean("isImport").booleanValue()) {
            if (rawScriptJson.containsKey("connect")) {
                connectionMapping.setSrcName(SqoopCommandUtils.getDatabaseFromUrl(rawScriptJson.getString("connect")));
                connectionMapping.setTgtName(SqoopCommandUtils.getDatabaseFromUrl(rawScriptJson.getString("connect")));
                connectionMapping.setSrcType(SqoopCommandUtils.getDatabaseTypeFromUrl(rawScriptJson.getString("connect")).getType());
                connectionMapping.setTgtType(SqoopCommandUtils.getDatabaseTypeFromUrl(rawScriptJson.getString("connect")).getType());
                return connectionMapping;
            }
        } else {
            if (rawScriptJson.containsKey("hcatalog-database")) {
                connectionMapping.setSrcName(rawScriptJson.getString("hcatalog-database"));
                connectionMapping.setTgtName(rawScriptJson.getString("hcatalog-database"));
                connectionMapping.setSrcType("hive");
                connectionMapping.setTgtType("odps");
                return connectionMapping;
            }
            if (rawScriptJson.containsKey("export-dir")) {
                connectionMapping.setSrcName(rawScriptJson.getString("export-dir"));
                connectionMapping.setTgtName(rawScriptJson.getString("export-dir"));
                connectionMapping.setSrcType("hive");
                connectionMapping.setTgtType("odps");
                return connectionMapping;
            }
            if (rawScriptJson.containsKey("hive-database")) {
                connectionMapping.setSrcName(rawScriptJson.getString("hive-database"));
                connectionMapping.setTgtName(rawScriptJson.getString("hive-database"));
                connectionMapping.setSrcType("hive");
                connectionMapping.setTgtType("odps");
                return connectionMapping;
            }
        }
        return null;
    }

    @Override
    public DiDatasourceMappingConfig.MigrationDatasourceConnectionMapping getTargetConnectionMapping(JSONObject rawScriptJson) {
        DiDatasourceMappingConfig.MigrationDatasourceConnectionMapping connectionMapping = new DiDatasourceMappingConfig.MigrationDatasourceConnectionMapping();
        if (rawScriptJson.getBoolean("isImport").booleanValue()) {
            if (rawScriptJson.containsKey("hcatalog-database")) {
                connectionMapping.setSrcName(rawScriptJson.getString("hcatalog-database"));
                connectionMapping.setTgtName(rawScriptJson.getString("hcatalog-database"));
                connectionMapping.setSrcType("hive");
                connectionMapping.setTgtType("odps");
                return connectionMapping;
            }
            if (rawScriptJson.containsKey("export-dir")) {
                connectionMapping.setSrcName(rawScriptJson.getString("export-dir"));
                connectionMapping.setTgtName(rawScriptJson.getString("export-dir"));
                connectionMapping.setSrcType("hive");
                connectionMapping.setTgtType("odps");
                return connectionMapping;
            }
            if (rawScriptJson.containsKey("hive-database")) {
                connectionMapping.setSrcName(rawScriptJson.getString("hive-database"));
                connectionMapping.setTgtName(rawScriptJson.getString("hive-database"));
                connectionMapping.setSrcType("hive");
                connectionMapping.setTgtType("odps");
                return connectionMapping;
            }
        } else if (rawScriptJson.containsKey("connect")) {
            connectionMapping.setSrcName(SqoopCommandUtils.getDatabaseFromUrl(rawScriptJson.getString("connect")));
            connectionMapping.setTgtName(SqoopCommandUtils.getDatabaseFromUrl(rawScriptJson.getString("connect")));
            connectionMapping.setSrcType(SqoopCommandUtils.getDatabaseTypeFromUrl(rawScriptJson.getString("connect")).getType());
            connectionMapping.setTgtType(SqoopCommandUtils.getDatabaseTypeFromUrl(rawScriptJson.getString("connect")).getType());
            return connectionMapping;
        }
        return null;
    }
}

