/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.migration.workflow.migration.common.transform.di.module;

import com.alibaba.fastjson2.JSONObject;
import com.aliyun.migration.workflow.migration.common.transform.di.domain.DiDatasourceMappingConfig;
import com.aliyun.migration.workflow.migration.common.transform.di.domain.DiScript;
import com.aliyun.migration.workflow.migration.common.transform.di.domain.DiScriptExtend;
import com.aliyun.migration.workflow.migration.common.transform.di.domain.DiScriptOrder;
import com.aliyun.migration.workflow.migration.common.transform.di.domain.DiScriptOrderHops;
import com.aliyun.migration.workflow.migration.common.transform.di.domain.DiScriptSetting;
import com.aliyun.migration.workflow.migration.common.transform.di.domain.DiScriptSettingSpeed;
import com.aliyun.migration.workflow.migration.common.transform.di.domain.DiScriptStep;
import com.aliyun.migration.workflow.migration.common.transform.di.module.AbstractDIScriptConvertFactory;
import com.aliyun.migration.workflow.migration.common.transform.di.module.DiStepTypeHandler;
import io.micrometer.common.util.StringUtils;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDIScriptConverter {
    private static final Logger log = LoggerFactory.getLogger(AbstractDIScriptConverter.class);
    private AbstractDIScriptConvertFactory readerConvertFactory;
    private AbstractDIScriptConvertFactory writerConvertFactory;

    public AbstractDIScriptConverter(AbstractDIScriptConvertFactory readerConvertFactory, AbstractDIScriptConvertFactory writerConvertFactory) {
        this.readerConvertFactory = readerConvertFactory;
        this.writerConvertFactory = writerConvertFactory;
    }

    public abstract JSONObject getRawScriptJson(String var1);

    public abstract String getSourceDatasourceName(JSONObject var1);

    public abstract String getSinkDatasourceName(JSONObject var1);

    public String getSourceDatabaseName(JSONObject rawScriptJson) {
        return null;
    }

    public String getSinkDatabaseName(JSONObject rawScriptJson) {
        return null;
    }

    public String convert(String rawScript, String configStr) {
        if (StringUtils.isBlank((String)rawScript)) {
            return null;
        }
        DiDatasourceMappingConfig diDatasourceMappingConfig = new DiDatasourceMappingConfig(configStr);
        JSONObject rawScriptJson = this.getRawScriptJson(rawScript);
        return this.convert(rawScriptJson, diDatasourceMappingConfig);
    }

    public String convert(String rawScript, DiDatasourceMappingConfig diDatasourceMappingConfig) {
        if (StringUtils.isBlank((String)rawScript)) {
            return null;
        }
        return this.convert(this.getRawScriptJson(rawScript), diDatasourceMappingConfig);
    }

    public DiDatasourceMappingConfig.MigrationDatasourceConnectionMapping getSourceConnectionMapping(JSONObject rawScriptJson) {
        return null;
    }

    public DiDatasourceMappingConfig.MigrationDatasourceConnectionMapping getTargetConnectionMapping(JSONObject rawScriptJson) {
        return null;
    }

    public String convert(JSONObject rawScriptJson, DiDatasourceMappingConfig diDatasourceMappingConfig) {
        if (rawScriptJson == null) {
            return null;
        }
        String sourceDatasourceName = this.getSourceDatasourceName(rawScriptJson);
        String sourceDatabaseName = this.getSourceDatabaseName(rawScriptJson);
        DiDatasourceMappingConfig.MigrationDatasourceConnectionMapping sourceConnectionMapping = null;
        sourceConnectionMapping = StringUtils.isEmpty((String)sourceDatabaseName) ? diDatasourceMappingConfig.getConnectionMapping(sourceDatasourceName, sourceDatabaseName, null, this.getSourceConnectionMapping(rawScriptJson)) : diDatasourceMappingConfig.getConnectionMapping(sourceDatasourceName, this.getSourceConnectionMapping(rawScriptJson));
        DiStepTypeHandler sourceConverter = this.readerConvertFactory.getConverter(sourceConnectionMapping);
        DiScriptStep sourceStep = new DiScriptStep();
        if (sourceConverter != null) {
            sourceStep = sourceConverter.convertToDwSourceStep(sourceConnectionMapping, rawScriptJson);
        } else {
            log.error("sourceConverter is null");
        }
        String sinkDatasourceName = this.getSinkDatasourceName(rawScriptJson);
        String sinkDatabaseName = this.getSinkDatabaseName(rawScriptJson);
        DiDatasourceMappingConfig.MigrationDatasourceConnectionMapping sinkConnectionMapping = null;
        sinkConnectionMapping = StringUtils.isEmpty((String)sinkDatabaseName) ? diDatasourceMappingConfig.getConnectionMapping(sinkDatasourceName, sinkDatabaseName, null, this.getTargetConnectionMapping(rawScriptJson)) : diDatasourceMappingConfig.getConnectionMapping(sinkDatasourceName, this.getTargetConnectionMapping(rawScriptJson));
        DiStepTypeHandler sinkConverter = this.writerConvertFactory.getConverter(sinkConnectionMapping);
        DiScriptStep sinkStep = new DiScriptStep();
        if (sinkConverter != null) {
            sinkStep = sinkConverter.convertToDwDestStep(sinkConnectionMapping, rawScriptJson);
        } else {
            log.error("sinkConverter is null");
        }
        DiScript diScript = this.converToDwDiScript(sourceStep, sinkStep, rawScriptJson);
        String diScriptstr = com.alibaba.fastjson.JSONObject.toJSONString((Object)diScript);
        return diScriptstr;
    }

    private DiScript converToDwDiScript(DiScriptStep sourceStep, DiScriptStep destStep, JSONObject rawScriptJson) {
        DiScript diScript = new DiScript();
        diScript.setType("job");
        diScript.setTransform(false);
        diScript.setVersion("2.0");
        ArrayList<DiScriptStep> steps = new ArrayList<DiScriptStep>();
        steps.add(sourceStep);
        steps.add(destStep);
        DiScriptSetting setting = new DiScriptSetting();
        setting.setSpeed(this.initializeDiScriptSettingSpeed());
        diScript.setSetting(setting);
        DiScriptExtend extend = new DiScriptExtend();
        extend.setMode("code");
        diScript.setExtend(extend);
        diScript.setOrder(this.initializeDiScriptOrder());
        diScript.setSteps(steps);
        return diScript;
    }

    private DiScriptSettingSpeed initializeDiScriptSettingSpeed() {
        DiScriptSettingSpeed diScriptSettingSpeed = new DiScriptSettingSpeed();
        diScriptSettingSpeed.setThrottle(false);
        diScriptSettingSpeed.setConcurrent(8);
        return diScriptSettingSpeed;
    }

    private DiScriptOrder initializeDiScriptOrder() {
        DiScriptOrder diScriptOrder = new DiScriptOrder();
        ArrayList<DiScriptOrderHops> hops = new ArrayList<DiScriptOrderHops>();
        DiScriptOrderHops diScriptOrderHops = new DiScriptOrderHops();
        diScriptOrderHops.setFrom("Reader");
        diScriptOrderHops.setTo("Writer");
        hops.add(diScriptOrderHops);
        diScriptOrder.setHops(hops);
        return diScriptOrder;
    }
}

