/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class Utils {
    private Utils() {
    }

    public static long dateToTimestamp(Date date) {
        return date.getTime() / 1000L;
    }

    public static Date timestampToDate(long timestamp) {
        return new Date(timestamp * 1000L);
    }

    public static String getOrEmpty(Map<String, String> map, String key) {
        return map.containsKey(key) ? map.get(key) : "";
    }

    public static String safeToString(Object object) {
        return object == null ? null : object.toString();
    }

    private static long parseLongWithoutSuffix(String s) {
        return Long.parseLong(s.substring(0, s.length() - 1).trim());
    }

    public static long parseDuration(String s) {
        if (s == null || s.isEmpty()) {
            throw new IllegalArgumentException("Duration could not be empty: " + s);
        }
        if (s.endsWith("s")) {
            return Utils.parseLongWithoutSuffix(s);
        }
        if (s.endsWith("m")) {
            return 60L * Utils.parseLongWithoutSuffix(s);
        }
        if (s.endsWith("h")) {
            return 3600L * Utils.parseLongWithoutSuffix(s);
        }
        if (s.endsWith("d")) {
            return 86400L * Utils.parseLongWithoutSuffix(s);
        }
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException ex) {
            throw new NumberFormatException("'" + s + "' is not a valid duration. Should be numeric value followed by a unit, i.e. 20s. Valid units are s, m, h and d.");
        }
    }

    public static boolean validateProject(String projectName) {
        if (projectName == null) {
            return false;
        }
        int n = projectName.length();
        if (n <= 0 || n > 128) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            char ch = projectName.charAt(i);
            if (ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || (ch == '-' || ch == '_') && i > 0 && i < n - 1) continue;
            return false;
        }
        return true;
    }

    public static String normalizeHostName(String hostName) {
        int n;
        for (n = hostName.length(); n > 0 && hostName.charAt(n - 1) == '/'; --n) {
        }
        if (n <= 0) {
            return null;
        }
        if (n < hostName.length()) {
            hostName = hostName.substring(0, n);
        }
        for (int i = 0; i < n; ++i) {
            char ch = hostName.charAt(i);
            if (ch == '-' || ch == '_' || ch == '.' || ch >= '0' && ch <= '9' || ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z') continue;
            return null;
        }
        return hostName;
    }

    public static String join(String delimiter, List<String> values) {
        if (values == null || values.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int idx = 0; idx < values.size(); ++idx) {
            if (idx == values.size() - 1) {
                sb.append(values.get(idx));
                continue;
            }
            sb.append(values.get(idx)).append(delimiter);
        }
        return sb.toString();
    }

    public static <T> List<T> removeNullItems(List<T> list) {
        ArrayList<T> nList = new ArrayList<T>(list);
        Iterator iter = nList.iterator();
        while (iter.hasNext()) {
            Object v = iter.next();
            if (v != null) continue;
            iter.remove();
        }
        return nList;
    }
}

