/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.request;

import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.log.request.TopostoreRequest;
import com.aliyun.openservices.log.util.Utils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.Map;

public class ListTopostoreRequest
extends TopostoreRequest {
    private Integer offset = 0;
    private Integer size = 200;
    private String tagKey;
    private String tagValue;
    private List<String> topostoreNames = new ArrayList<String>();
    private Map<String, String> tags;

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public ListTopostoreRequest(Integer offset, Integer size, String tagKey, String tagValue, List<String> topostoreNames) {
        this.offset = offset;
        this.size = size;
        this.tagKey = tagKey;
        this.tagValue = tagValue;
        this.topostoreNames = topostoreNames;
    }

    public ListTopostoreRequest() {
    }

    public ListTopostoreRequest(String tagKey, String tagValue) {
        this.tagKey = tagKey;
        this.tagValue = tagValue;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public String getTagKey() {
        return this.tagKey;
    }

    public void setTagKey(String tagKey) {
        this.tagKey = tagKey;
    }

    public String getTagValue() {
        return this.tagValue;
    }

    public void setTagValue(String tagValue) {
        this.tagValue = tagValue;
    }

    public List<String> getTopostoreNames() {
        return this.topostoreNames;
    }

    public void setTopostoreNames(List<String> topostoreNames) {
        this.topostoreNames = topostoreNames;
    }

    @Override
    public Map<String, String> GetAllParams() {
        if (this.offset != null) {
            this.SetParam("offset", this.offset.toString());
        }
        if (this.size != null) {
            this.SetParam("size", this.size.toString());
        }
        if (this.tagKey != null) {
            this.SetParam("tagKey", this.tagKey);
        }
        if (this.tagValue != null) {
            this.SetParam("tagValue", this.tagValue);
        }
        if (this.tags != null) {
            JSONObject tagObj = new JSONObject();
            for (Map.Entry<String, String> kv : this.tags.entrySet()) {
                tagObj.put(kv.getKey(), (Object)kv.getValue());
            }
            try {
                this.SetParam("tags", URLEncoder.encode(new String(Base64.getEncoder().encodeToString(tagObj.toJSONString().getBytes())), "utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.topostoreNames != null && !this.topostoreNames.isEmpty()) {
            this.SetParam("names", Utils.join(",", this.topostoreNames));
        }
        return super.GetAllParams();
    }
}

