/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.http.utils;

import com.aliyun.log.thirdparty.org.apache.http.NoHttpResponseException;
import com.aliyun.log.thirdparty.org.apache.http.client.ClientProtocolException;
import com.aliyun.log.thirdparty.org.apache.http.client.NonRepeatableRequestException;
import com.aliyun.log.thirdparty.org.apache.http.conn.ConnectTimeoutException;
import com.aliyun.log.thirdparty.org.apache.http.conn.HttpHostConnectException;
import com.aliyun.openservices.log.http.client.ClientException;
import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import javax.net.ssl.SSLException;

public class ExceptionFactory {
    public static ClientException createNetworkException(IOException ex) {
        Throwable cause;
        String requestId = "Unknown";
        String errorCode = "Unknown";
        if (ex instanceof SocketTimeoutException) {
            errorCode = "SocketTimeout";
        } else if (ex instanceof HttpHostConnectException) {
            errorCode = "ConnectionRefused";
        } else if (ex instanceof SocketException) {
            errorCode = "SocketException";
        } else if (ex instanceof ConnectTimeoutException) {
            errorCode = "ConnectionTimeout";
        } else if (ex instanceof UnknownHostException) {
            errorCode = "UnknownHost";
        } else if (ex instanceof NoHttpResponseException) {
            errorCode = "ConnectionTimeout";
        } else if (ex instanceof SSLException) {
            errorCode = "SslException";
        } else if (ex instanceof ClientProtocolException && (cause = ex.getCause()) instanceof NonRepeatableRequestException) {
            errorCode = "NonRepeatableRequest";
            return new ClientException(cause.getMessage(), errorCode, requestId, cause);
        }
        return new ClientException(ex.getMessage(), errorCode, requestId, ex);
    }
}

