/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.http.comm;

import com.aliyun.log.thirdparty.org.apache.http.conn.HttpClientConnectionManager;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public final class IdleConnectionReaper
extends Thread {
    private static final int REAP_INTERVAL_MILLISECONDS = 5000;
    private static final ArrayList<HttpClientConnectionManager> connectionManagers = new ArrayList();
    private static IdleConnectionReaper instance;
    private static long idleConnectionTime;
    private volatile boolean shuttingDown = false;

    private IdleConnectionReaper() {
        super("idle_connection_reaper");
        this.setDaemon(true);
    }

    public static synchronized void registerConnectionManager(HttpClientConnectionManager connectionManager) {
        if (instance == null) {
            instance = new IdleConnectionReaper();
            instance.start();
        }
        connectionManagers.add(connectionManager);
    }

    public static synchronized void removeConnectionManager(HttpClientConnectionManager connectionManager) {
        connectionManagers.remove(connectionManager);
        if (connectionManagers.isEmpty()) {
            IdleConnectionReaper.shutdown();
        }
    }

    private void markShuttingDown() {
        this.shuttingDown = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        block8: while (!this.shuttingDown) {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                List connectionManagers = null;
                Object object = IdleConnectionReaper.class;
                // MONITORENTER : com.aliyun.openservices.log.http.comm.IdleConnectionReaper.class
                connectionManagers = (List)IdleConnectionReaper.connectionManagers.clone();
                // MONITOREXIT : object
                object = connectionManagers.iterator();
                while (true) {
                    if (!object.hasNext()) continue block8;
                    HttpClientConnectionManager connectionManager = (HttpClientConnectionManager)object.next();
                    try {
                        connectionManager.closeExpiredConnections();
                        connectionManager.closeIdleConnections(idleConnectionTime, TimeUnit.MILLISECONDS);
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Throwable throwable) {
            }
        }
    }

    public static synchronized void shutdown() {
        if (instance != null) {
            instance.markShuttingDown();
            instance.interrupt();
            connectionManagers.clear();
            instance = null;
        }
    }

    public static synchronized void setIdleConnectionTime(long idletime) {
        idleConnectionTime = idletime;
    }

    static {
        idleConnectionTime = 60000L;
    }
}

