/*
 * Decompiled with CFR 0.152.
 */
package azkaban.utils;

import azkaban.utils.OsMemoryUtil;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemMemoryInfo {
    private static final Logger logger = LoggerFactory.getLogger(SystemMemoryInfo.class);
    private static final long LOW_MEM_THRESHOLD = 0x300000L;
    private final OsMemoryUtil util;

    @Inject
    public SystemMemoryInfo(OsMemoryUtil util) {
        this.util = util;
    }

    public boolean canSystemGrantMemory(long xmx) {
        long freeMemSize = this.util.getOsTotalFreeMemorySize();
        if (freeMemSize == 0L) {
            return true;
        }
        if (freeMemSize - xmx < 0x300000L) {
            logger.info(String.format("Free memory amount minus Xmx (%d - %d kb) is less than low mem threshold (%d kb), memory request declined.", freeMemSize, xmx, 0x300000L));
            return false;
        }
        return true;
    }
}

