/*
 * Decompiled with CFR 0.152.
 */
package azkaban.utils;

import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class StdOutErrRedirect {
    private static final Logger logger = Logger.getLogger(StdOutErrRedirect.class);
    private static final PrintStream infoStream = StdOutErrRedirect.createStream(System.out, Level.INFO);
    private static final PrintStream errorStream = StdOutErrRedirect.createStream(System.out, Level.ERROR);

    public static void redirectOutAndErrToLog() {
        System.setOut(infoStream);
        System.setErr(errorStream);
    }

    private static PrintStream createStream(PrintStream stream, Level level) {
        return new LogStream((OutputStream)stream, level);
    }

    private static class LogStream
    extends PrintStream {
        private final Level level;

        public LogStream(OutputStream out, Level level) {
            super(out);
            this.level = level;
        }

        private void write(String string) {
            logger.log((Priority)this.level, (Object)string);
        }

        @Override
        public void println(String string) {
            this.print(string);
        }

        @Override
        public void print(String string) {
            this.write(string);
        }

        @Override
        public void println(boolean bool) {
            this.print(bool);
        }

        @Override
        public void print(boolean bool) {
            this.write(String.valueOf(bool));
        }

        @Override
        public void println(int i) {
            this.print(i);
        }

        @Override
        public void print(int i) {
            this.write(String.valueOf(i));
        }

        @Override
        public void println(float f) {
            this.print(f);
        }

        @Override
        public void print(float f) {
            this.write(String.valueOf(f));
        }

        @Override
        public void println(char c) {
            this.print(c);
        }

        @Override
        public void print(char c) {
            this.write(String.valueOf(c));
        }

        @Override
        public void println(long l) {
            this.print(l);
        }

        @Override
        public void print(long l) {
            this.write(String.valueOf(l));
        }

        @Override
        public void println(double d) {
            this.print(d);
        }

        @Override
        public void print(double d) {
            this.write(String.valueOf(d));
        }

        @Override
        public void println(char[] c) {
            this.print(c);
        }

        @Override
        public void print(char[] c) {
            this.write(new String(c));
        }

        @Override
        public void println(Object o) {
            this.print(o);
        }

        @Override
        public void print(Object o) {
            this.write(o.toString());
        }
    }
}

