/*
 * Decompiled with CFR 0.152.
 */
package azkaban.utils;

import azkaban.db.EncodingType;
import azkaban.utils.JSONUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;

public class GZIPUtils {
    public static byte[] gzipString(String str, String encType) throws IOException {
        byte[] stringData = str.getBytes(encType);
        return GZIPUtils.gzipBytes(stringData);
    }

    public static byte[] gzipBytes(byte[] bytes) throws IOException {
        return GZIPUtils.gzipBytes(bytes, 0, bytes.length);
    }

    public static byte[] gzipBytes(byte[] bytes, int offset, int length) throws IOException {
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gzipStream = null;
        gzipStream = new GZIPOutputStream(byteOutputStream);
        gzipStream.write(bytes, offset, length);
        gzipStream.close();
        return byteOutputStream.toByteArray();
    }

    public static byte[] unGzipBytes(byte[] bytes) throws IOException {
        ByteArrayInputStream byteInputStream = new ByteArrayInputStream(bytes);
        GZIPInputStream gzipInputStream = new GZIPInputStream(byteInputStream);
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)gzipInputStream, (OutputStream)byteOutputStream);
        return byteOutputStream.toByteArray();
    }

    public static String unGzipString(byte[] bytes, String encType) throws IOException {
        byte[] response = GZIPUtils.unGzipBytes(bytes);
        return new String(response, encType);
    }

    public static Object transformBytesToObject(byte[] data, EncodingType encType) throws IOException {
        if (encType == EncodingType.GZIP) {
            String jsonString = GZIPUtils.unGzipString(data, "UTF-8");
            return JSONUtils.parseJSONFromString((String)jsonString);
        }
        String jsonString = new String(data, "UTF-8");
        return JSONUtils.parseJSONFromString((String)jsonString);
    }
}

