/*
 * Decompiled with CFR 0.152.
 */
package azkaban.utils;

import azkaban.alert.Alerter;
import azkaban.executor.ExecutableFlow;
import azkaban.executor.Executor;
import azkaban.executor.ExecutorLoader;
import azkaban.executor.ExecutorManagerException;
import azkaban.executor.mail.DefaultMailCreator;
import azkaban.executor.mail.MailCreator;
import azkaban.metrics.CommonMetrics;
import azkaban.sla.SlaOption;
import azkaban.utils.AbstractMailer;
import azkaban.utils.EmailMessage;
import azkaban.utils.EmailMessageCreator;
import azkaban.utils.Props;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.mail.internet.AddressException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

@Singleton
public class Emailer
extends AbstractMailer
implements Alerter {
    private static final String HTTPS = "https";
    private static final String HTTP = "http";
    private static final Logger logger = Logger.getLogger(Emailer.class);
    private final CommonMetrics commonMetrics;
    private final String scheme;
    private final String clientHostname;
    private final String clientPortNumber;
    private final String azkabanName;
    private final ExecutorLoader executorLoader;

    @Inject
    public Emailer(Props props, CommonMetrics commonMetrics, EmailMessageCreator messageCreator, ExecutorLoader executorLoader) {
        super(props, messageCreator);
        this.executorLoader = Objects.requireNonNull(executorLoader, "executorLoader is null.");
        this.commonMetrics = Objects.requireNonNull(commonMetrics, "commonMetrics is null.");
        this.azkabanName = props.getString("azkaban.name", "azkaban");
        int mailTimeout = props.getInt("mail.timeout.millis", 30000);
        EmailMessage.setTimeout(mailTimeout);
        int connectionTimeout = props.getInt("mail.connection.timeout.millis", 30000);
        EmailMessage.setConnectionTimeout(connectionTimeout);
        EmailMessage.setTotalAttachmentMaxSize(this.getAttachmentMaxSize());
        this.clientHostname = props.getString("azkaban.webserver.external_hostname", props.getString("jetty.hostname", "localhost"));
        if (props.getBoolean("jetty.use.ssl", true)) {
            this.scheme = HTTPS;
            this.clientPortNumber = Integer.toString(props.getInt("azkaban.webserver.external_ssl_port", props.getInt("jetty.ssl.port", 8443)));
        } else {
            this.scheme = HTTP;
            this.clientPortNumber = Integer.toString(props.getInt("azkaban.webserver.external_port", props.getInt("jetty.port", 8081)));
        }
    }

    public String getAzkabanURL() {
        return this.scheme + "://" + this.clientHostname + ":" + this.clientPortNumber;
    }

    public void sendEmail(List<String> emailList, String subject, String body) {
        if (emailList != null && !emailList.isEmpty()) {
            EmailMessage message = super.createEmailMessage(subject, "text/html", emailList);
            message.setBody(body);
            this.sendEmail(message, true, "email message " + body);
        }
    }

    @Override
    public void alertOnSla(SlaOption slaOption, String slaMessage) {
        String subject = "SLA violation for " + this.getJobOrFlowName(slaOption) + " on " + this.getAzkabanName();
        List emailList = (List)slaOption.getInfo().get("EmailList");
        logger.info((Object)("Sending SLA email " + slaMessage));
        this.sendEmail(emailList, subject, slaMessage);
    }

    @Override
    public void alertOnFirstError(ExecutableFlow flow) {
        EmailMessage message = this.messageCreator.createMessage();
        MailCreator mailCreator = this.getMailCreator(flow);
        boolean mailCreated = mailCreator.createFirstErrorMessage(flow, message, this.azkabanName, this.scheme, this.clientHostname, this.clientPortNumber);
        this.sendEmail(message, mailCreated, "first error email message for execution " + flow.getExecutionId());
    }

    @Override
    public void alertOnError(ExecutableFlow flow, String ... extraReasons) {
        EmailMessage message = this.messageCreator.createMessage();
        MailCreator mailCreator = this.getMailCreator(flow);
        List<ExecutableFlow> last72hoursExecutions = new ArrayList<ExecutableFlow>();
        if (flow.getStartTime() > 0L) {
            long startTime = flow.getStartTime() - Duration.ofHours(72L).toMillis();
            try {
                last72hoursExecutions = this.executorLoader.fetchFlowHistory(flow.getProjectId(), flow.getFlowId(), startTime);
            }
            catch (ExecutorManagerException e) {
                logger.error((Object)"unable to fetch past executions", (Throwable)e);
            }
        }
        boolean mailCreated = mailCreator.createErrorEmail(flow, last72hoursExecutions, message, this.azkabanName, this.scheme, this.clientHostname, this.clientPortNumber, extraReasons);
        this.sendEmail(message, mailCreated, "error email message for execution " + flow.getExecutionId());
    }

    @Override
    public void alertOnSuccess(ExecutableFlow flow) {
        EmailMessage message = this.messageCreator.createMessage();
        MailCreator mailCreator = this.getMailCreator(flow);
        boolean mailCreated = mailCreator.createSuccessEmail(flow, message, this.azkabanName, this.scheme, this.clientHostname, this.clientPortNumber);
        this.sendEmail(message, mailCreated, "success email message for execution " + flow.getExecutionId());
    }

    @Override
    public void alertOnFailedUpdate(Executor executor, List<ExecutableFlow> flows, ExecutorManagerException updateException) {
        flows = flows.stream().filter(flow -> flow.getExecutionOptions() != null).filter(flow -> CollectionUtils.isNotEmpty(flow.getExecutionOptions().getFailureEmails())).collect(Collectors.toList());
        ImmutableListMultimap creatorsToFlows = Multimaps.index(flows, flow -> flow.getExecutionOptions().getMailCreator());
        for (String mailCreatorName : creatorsToFlows.keySet()) {
            ImmutableList creatorFlows = creatorsToFlows.get((Object)mailCreatorName);
            MailCreator mailCreator = this.getMailCreator(mailCreatorName);
            ImmutableListMultimap emailsToFlows = Multimaps.index((Iterable)creatorFlows, flow -> flow.getExecutionOptions().getFailureEmails());
            for (List emailList : emailsToFlows.keySet()) {
                this.sendFailedUpdateEmail(executor, updateException, mailCreator, (ImmutableList<ExecutableFlow>)emailsToFlows.get((Object)emailList));
            }
        }
    }

    private void sendFailedUpdateEmail(Executor executor, ExecutorManagerException exception, MailCreator mailCreator, ImmutableList<ExecutableFlow> flows) {
        EmailMessage message = this.messageCreator.createMessage();
        boolean mailCreated = mailCreator.createFailedUpdateMessage((List<ExecutableFlow>)flows, executor, exception, message, this.azkabanName, this.scheme, this.clientHostname, this.clientPortNumber);
        List executionIds = Lists.transform(flows, ExecutableFlow::getExecutionId);
        this.sendEmail(message, mailCreated, "failed update email message for executions " + executionIds);
    }

    private MailCreator getMailCreator(ExecutableFlow flow) {
        String name = flow.getExecutionOptions().getMailCreator();
        return this.getMailCreator(name);
    }

    private MailCreator getMailCreator(String name) {
        MailCreator mailCreator = DefaultMailCreator.getCreator(name);
        logger.debug((Object)("ExecutorMailer using mail creator:" + mailCreator.getClass().getCanonicalName()));
        return mailCreator;
    }

    public void sendEmail(EmailMessage message, boolean mailCreated, String operation) {
        block3: {
            if (mailCreated) {
                try {
                    message.sendEmail();
                    logger.info((Object)("Sent " + operation));
                    this.commonMetrics.markSendEmailSuccess();
                }
                catch (Exception e) {
                    logger.error((Object)("Failed to send " + operation), (Throwable)e);
                    if (e instanceof AddressException) break block3;
                    this.commonMetrics.markSendEmailFail();
                }
            }
        }
    }

    private String getJobOrFlowName(SlaOption slaOption) {
        String flowName = (String)slaOption.getInfo().get("FlowName");
        String jobName = (String)slaOption.getInfo().get("JobName");
        if (StringUtils.isNotBlank((String)jobName)) {
            return flowName + ":" + jobName;
        }
        return flowName;
    }
}

