/*
 * Decompiled with CFR 0.152.
 */
package azkaban.utils;

import azkaban.utils.EmailMessageCreator;
import azkaban.utils.JavaxMailSender;
import azkaban.utils.MessageAttachmentExceededMaximumSizeException;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.apache.log4j.Logger;

public class EmailMessage {
    private static final int MAX_EMAIL_RETRY_COUNT = 5;
    private static int _mailTimeout = 10000;
    private static int _connectionTimeout = 10000;
    private static long _totalAttachmentMaxSizeInByte = 0x40000000L;
    private final Logger logger = Logger.getLogger(EmailMessage.class);
    private final List<String> _toAddress = new ArrayList<String>();
    private final int _mailPort;
    private final ArrayList<BodyPart> _attachments = new ArrayList();
    private final String _mailHost;
    private final String _mailUser;
    private final String _mailPassword;
    private final EmailMessageCreator creator;
    private String _subject;
    private String _fromAddress;
    private String _mimeType = "text/plain";
    private String _tls;
    private long _totalAttachmentSizeSoFar;
    private boolean _usesAuth = true;
    private boolean _enableAttachementEmbedment = true;
    private StringBuffer _body = new StringBuffer();

    public EmailMessage(String host, int port, String user, String password, EmailMessageCreator creator) {
        this._mailUser = user;
        this._mailHost = host;
        this._mailPort = port;
        this._mailPassword = password;
        this.creator = creator;
    }

    public static void setTimeout(int timeoutMillis) {
        _mailTimeout = timeoutMillis;
    }

    public static void setConnectionTimeout(int timeoutMillis) {
        _connectionTimeout = timeoutMillis;
    }

    public static void setTotalAttachmentMaxSize(long sizeInBytes) {
        if (sizeInBytes < 1L) {
            throw new IllegalArgumentException("attachment max size can't be 0 or negative");
        }
        _totalAttachmentMaxSizeInByte = sizeInBytes;
    }

    public EmailMessage enableAttachementEmbedment(boolean toEnable) {
        this._enableAttachementEmbedment = toEnable;
        return this;
    }

    public EmailMessage addAllToAddress(Collection<? extends String> addresses) {
        this._toAddress.addAll(addresses);
        return this;
    }

    public EmailMessage addToAddress(String address) {
        this._toAddress.add(address);
        return this;
    }

    public EmailMessage setFromAddress(String fromAddress) {
        this._fromAddress = fromAddress;
        return this;
    }

    public EmailMessage setTLS(String tls) {
        this._tls = tls;
        return this;
    }

    public EmailMessage setAuth(boolean auth) {
        this._usesAuth = auth;
        return this;
    }

    public EmailMessage addAttachment(File file) throws MessagingException {
        return this.addAttachment(file.getName(), file);
    }

    public EmailMessage addAttachment(String attachmentName, File file) throws MessagingException {
        this._totalAttachmentSizeSoFar += file.length();
        if (this._totalAttachmentSizeSoFar > _totalAttachmentMaxSizeInByte) {
            throw new MessageAttachmentExceededMaximumSizeException("Adding attachment '" + attachmentName + "' will exceed the allowed maximum size of " + _totalAttachmentMaxSizeInByte);
        }
        MimeBodyPart attachmentPart = new MimeBodyPart();
        FileDataSource fileDataSource = new FileDataSource(file);
        attachmentPart.setDataHandler(new DataHandler((DataSource)fileDataSource));
        attachmentPart.setFileName(attachmentName);
        this._attachments.add((BodyPart)attachmentPart);
        return this;
    }

    public EmailMessage addAttachment(String attachmentName, InputStream stream) throws MessagingException {
        MimeBodyPart attachmentPart = new MimeBodyPart(stream);
        attachmentPart.setFileName(attachmentName);
        this._attachments.add((BodyPart)attachmentPart);
        return this;
    }

    private void checkSettings() {
        if (this._mailHost == null) {
            throw new RuntimeException("Mail host not set.");
        }
        if (this._fromAddress == null || this._fromAddress.length() == 0) {
            throw new RuntimeException("From address not set.");
        }
        if (this._subject == null) {
            throw new RuntimeException("Subject cannot be null");
        }
        if (this._toAddress.size() == 0) {
            throw new RuntimeException("T");
        }
    }

    public void sendEmail() throws MessagingException {
        this.checkSettings();
        Properties props = new Properties();
        if (this._usesAuth) {
            props.put("mail.smtp.auth", "true");
            props.put("mail.user", this._mailUser);
            props.put("mail.password", this._mailPassword);
        } else {
            props.put("mail.smtp.auth", "false");
        }
        props.put("mail.smtp.host", this._mailHost);
        props.put("mail.smtp.port", (Object)this._mailPort);
        props.put("mail.smtp.timeout", (Object)_mailTimeout);
        props.put("mail.smtp.connectiontimeout", (Object)_connectionTimeout);
        props.put("mail.smtp.starttls.enable", this._tls);
        props.put("mail.smtp.ssl.trust", this._mailHost);
        JavaxMailSender sender = this.creator.createSender(props);
        Message message = sender.createMessage();
        InternetAddress from = new InternetAddress(this._fromAddress, false);
        message.setFrom((Address)from);
        for (String toAddr : this._toAddress) {
            message.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(toAddr, false));
        }
        message.setSubject(this._subject);
        message.setSentDate(new Date());
        if (this._attachments.size() > 0) {
            MimeMultipart multipart = this._enableAttachementEmbedment ? new MimeMultipart("related") : new MimeMultipart();
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            messageBodyPart.setContent((Object)this._body.toString(), this._mimeType);
            multipart.addBodyPart((BodyPart)messageBodyPart);
            for (BodyPart part : this._attachments) {
                multipart.addBodyPart(part);
            }
            message.setContent((Multipart)multipart);
        } else {
            message.setContent((Object)this._body.toString(), this._mimeType);
        }
        this.retryConnectToSMTPServer(sender);
        this.retrySendMessage(sender, message);
        sender.close();
    }

    private void connectToSMTPServer(JavaxMailSender s) throws MessagingException {
        if (this._usesAuth) {
            s.connect(this._mailHost, this._mailPort, this._mailUser, this._mailPassword);
        } else {
            s.connect();
        }
    }

    private void retryConnectToSMTPServer(JavaxMailSender s) throws MessagingException {
        int attempt;
        for (attempt = 0; attempt < 5; ++attempt) {
            try {
                this.connectToSMTPServer(s);
                return;
            }
            catch (Exception e) {
                this.logger.error((Object)("Connecting to SMTP server failed, attempt: " + attempt), (Throwable)e);
                continue;
            }
        }
        s.close();
        throw new MessagingException("Failed to connect to SMTP server after " + attempt + " attempts.");
    }

    private void retrySendMessage(JavaxMailSender s, Message message) throws MessagingException {
        int attempt;
        for (attempt = 0; attempt < 5; ++attempt) {
            try {
                s.sendMessage(message, message.getRecipients(Message.RecipientType.TO));
                return;
            }
            catch (Exception e) {
                this.logger.error((Object)("Sending email messages failed, attempt: " + attempt), (Throwable)e);
                continue;
            }
        }
        s.close();
        throw new MessagingException("Failed to send email messages after " + attempt + " attempts.");
    }

    public void setBody(String body, String mimeType) {
        this._body = new StringBuffer(body);
        this._mimeType = mimeType;
    }

    public EmailMessage setMimeType(String mimeType) {
        this._mimeType = mimeType;
        return this;
    }

    public EmailMessage println(Object str) {
        this._body.append(str);
        return this;
    }

    public String getBody() {
        return this._body.toString();
    }

    public void setBody(String body) {
        this.setBody(body, this._mimeType);
    }

    public String getSubject() {
        return this._subject;
    }

    public EmailMessage setSubject(String subject) {
        this._subject = subject;
        return this;
    }

    public int getMailPort() {
        return this._mailPort;
    }
}

