/*
 * Decompiled with CFR 0.152.
 */
package azkaban.utils;

import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.AuthenticatedURL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthenticationUtils {
    private static final Logger logger = LoggerFactory.getLogger(AuthenticationUtils.class);

    public static HttpURLConnection loginAuthenticatedURL(URL url, String keytabPrincipal, String keytabPath) throws Exception {
        ArrayList<URL> resources = new ArrayList<URL>();
        resources.add(url);
        URLClassLoader ucl = new URLClassLoader(resources.toArray(new URL[resources.size()]));
        Configuration conf = new Configuration();
        conf.setClassLoader((ClassLoader)ucl);
        UserGroupInformation.setConfiguration((Configuration)conf);
        logger.info("Logging in URL: " + url.toString() + " using Principal: " + keytabPrincipal + ", Keytab: " + keytabPath);
        UserGroupInformation.loginUserFromKeytab((String)keytabPrincipal, (String)keytabPath);
        HttpURLConnection connection = (HttpURLConnection)UserGroupInformation.getLoginUser().doAs(() -> {
            AuthenticatedURL.Token token = new AuthenticatedURL.Token();
            return new AuthenticatedURL().openConnection(url, token);
        });
        return connection;
    }
}

