/*
 * Decompiled with CFR 0.152.
 */
package azkaban.utils;

import azkaban.utils.EmailMessage;
import azkaban.utils.EmailMessageCreator;
import azkaban.utils.Props;
import java.util.Collection;

public class AbstractMailer {
    private static final int MB_IN_BYTES = 0x100000;
    protected final EmailMessageCreator messageCreator;
    private final String azkabanName;
    private final long attachmentMazSizeInByte;

    public AbstractMailer(Props props, EmailMessageCreator messageCreator) {
        this.azkabanName = props.getString("azkaban.name", "azkaban");
        this.messageCreator = messageCreator;
        long maxAttachmentSizeInMB = props.getInt("mail.max.attachment.size.mb", 100);
        this.attachmentMazSizeInByte = maxAttachmentSizeInMB * 0x100000L;
    }

    public EmailMessage createEmailMessage(String subject, String mimetype, Collection<String> emailList) {
        EmailMessage message = this.messageCreator.createMessage();
        message.addAllToAddress(emailList);
        message.setMimeType(mimetype);
        message.setSubject(subject);
        return message;
    }

    public String getAzkabanName() {
        return this.azkabanName;
    }

    long getAttachmentMaxSize() {
        return this.attachmentMazSizeInByte;
    }
}

