/*
 * Decompiled with CFR 0.152.
 */
package azkaban.trigger.builtin;

import azkaban.ServiceProvider;
import azkaban.executor.ExecutableFlow;
import azkaban.executor.ExecutableNode;
import azkaban.executor.ExecutorLoader;
import azkaban.executor.ExecutorManagerException;
import azkaban.executor.Status;
import azkaban.sla.SlaOption;
import azkaban.trigger.ConditionChecker;
import azkaban.utils.TimeUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.ReadablePeriod;

public class SlaChecker
implements ConditionChecker {
    public static final String type = "SlaChecker";
    private static final Logger logger = Logger.getLogger(SlaChecker.class);
    private final String id;
    private final SlaOption slaOption;
    private final int execId;
    private final ExecutorLoader executorLoader;
    private long checkTime = -1L;

    public SlaChecker(String id, SlaOption slaOption, int execId) {
        this.id = id;
        this.slaOption = slaOption;
        this.execId = execId;
        this.executorLoader = ServiceProvider.SERVICE_PROVIDER.getInstance(ExecutorLoader.class);
    }

    public static SlaChecker createFromJson(Object obj) throws Exception {
        return SlaChecker.createFromJson((HashMap)obj);
    }

    public static SlaChecker createFromJson(HashMap<String, Object> obj) throws Exception {
        HashMap<String, Object> jsonObj = obj;
        if (!jsonObj.get("type").equals(type)) {
            throw new Exception("Cannot create checker of SlaChecker from " + jsonObj.get("type"));
        }
        String id = (String)jsonObj.get("id");
        SlaOption slaOption = SlaOption.fromObject(jsonObj.get("slaOption"));
        int execId = Integer.valueOf((String)jsonObj.get("execId"));
        return new SlaChecker(id, slaOption, execId);
    }

    private Boolean isSlaMissed(ExecutableFlow flow) {
        String type = this.slaOption.getType();
        if (flow.getStartTime() < 0L) {
            return Boolean.FALSE;
        }
        if (type.equals("FlowFinish")) {
            if (this.checkTime < flow.getStartTime()) {
                ReadablePeriod duration = TimeUtils.parsePeriodString((String)((String)this.slaOption.getInfo().get("Duration")));
                DateTime startTime = new DateTime(flow.getStartTime());
                DateTime nextCheckTime = startTime.plus(duration);
                this.checkTime = nextCheckTime.getMillis();
            }
            Status status = flow.getStatus();
            if (this.checkTime < DateTime.now().getMillis()) {
                return !this.isFlowFinished(status);
            }
        } else {
            if (type.equals("FlowSucceed")) {
                if (this.checkTime < flow.getStartTime()) {
                    ReadablePeriod duration = TimeUtils.parsePeriodString((String)((String)this.slaOption.getInfo().get("Duration")));
                    DateTime startTime = new DateTime(flow.getStartTime());
                    DateTime nextCheckTime = startTime.plus(duration);
                    this.checkTime = nextCheckTime.getMillis();
                }
                Status status = flow.getStatus();
                if (this.checkTime < DateTime.now().getMillis()) {
                    return !this.isFlowSucceeded(status);
                }
                return status.equals((Object)Status.FAILED) || status.equals((Object)Status.KILLED);
            }
            if (type.equals("JobFinish")) {
                String jobName = (String)this.slaOption.getInfo().get("JobName");
                ExecutableNode node = flow.getExecutableNode(jobName);
                if (node.getStartTime() < 0L) {
                    return Boolean.FALSE;
                }
                if (this.checkTime < node.getStartTime()) {
                    ReadablePeriod duration = TimeUtils.parsePeriodString((String)((String)this.slaOption.getInfo().get("Duration")));
                    DateTime startTime = new DateTime(node.getStartTime());
                    DateTime nextCheckTime = startTime.plus(duration);
                    this.checkTime = nextCheckTime.getMillis();
                }
                Status status = node.getStatus();
                if (this.checkTime < DateTime.now().getMillis()) {
                    return !this.isJobFinished(status);
                }
            } else if (type.equals("JobSucceed")) {
                String jobName = (String)this.slaOption.getInfo().get("JobName");
                ExecutableNode node = flow.getExecutableNode(jobName);
                if (node.getStartTime() < 0L) {
                    return Boolean.FALSE;
                }
                if (this.checkTime < node.getStartTime()) {
                    ReadablePeriod duration = TimeUtils.parsePeriodString((String)((String)this.slaOption.getInfo().get("Duration")));
                    DateTime startTime = new DateTime(node.getStartTime());
                    DateTime nextCheckTime = startTime.plus(duration);
                    this.checkTime = nextCheckTime.getMillis();
                }
                Status status = node.getStatus();
                if (this.checkTime < DateTime.now().getMillis()) {
                    return !this.isJobFinished(status);
                }
                return status.equals((Object)Status.FAILED) || status.equals((Object)Status.KILLED);
            }
        }
        return Boolean.FALSE;
    }

    private Boolean isSlaGood(ExecutableFlow flow) {
        String type = this.slaOption.getType();
        if (flow.getStartTime() < 0L) {
            return Boolean.FALSE;
        }
        if (type.equals("FlowFinish")) {
            if (this.checkTime < flow.getStartTime()) {
                ReadablePeriod duration = TimeUtils.parsePeriodString((String)((String)this.slaOption.getInfo().get("Duration")));
                DateTime startTime = new DateTime(flow.getStartTime());
                DateTime nextCheckTime = startTime.plus(duration);
                this.checkTime = nextCheckTime.getMillis();
            }
            Status status = flow.getStatus();
            return this.isFlowFinished(status);
        }
        if (type.equals("FlowSucceed")) {
            if (this.checkTime < flow.getStartTime()) {
                ReadablePeriod duration = TimeUtils.parsePeriodString((String)((String)this.slaOption.getInfo().get("Duration")));
                DateTime startTime = new DateTime(flow.getStartTime());
                DateTime nextCheckTime = startTime.plus(duration);
                this.checkTime = nextCheckTime.getMillis();
            }
            Status status = flow.getStatus();
            return this.isFlowSucceeded(status);
        }
        if (type.equals("JobFinish")) {
            String jobName = (String)this.slaOption.getInfo().get("JobName");
            ExecutableNode node = flow.getExecutableNode(jobName);
            if (node.getStartTime() < 0L) {
                return Boolean.FALSE;
            }
            if (this.checkTime < node.getStartTime()) {
                ReadablePeriod duration = TimeUtils.parsePeriodString((String)((String)this.slaOption.getInfo().get("Duration")));
                DateTime startTime = new DateTime(node.getStartTime());
                DateTime nextCheckTime = startTime.plus(duration);
                this.checkTime = nextCheckTime.getMillis();
            }
            Status status = node.getStatus();
            return this.isJobFinished(status);
        }
        if (type.equals("JobSucceed")) {
            String jobName = (String)this.slaOption.getInfo().get("JobName");
            ExecutableNode node = flow.getExecutableNode(jobName);
            if (node.getStartTime() < 0L) {
                return Boolean.FALSE;
            }
            if (this.checkTime < node.getStartTime()) {
                ReadablePeriod duration = TimeUtils.parsePeriodString((String)((String)this.slaOption.getInfo().get("Duration")));
                DateTime startTime = new DateTime(node.getStartTime());
                DateTime nextCheckTime = startTime.plus(duration);
                this.checkTime = nextCheckTime.getMillis();
            }
            Status status = node.getStatus();
            return this.isJobSucceeded(status);
        }
        return Boolean.FALSE;
    }

    @Override
    public Object eval() {
        ExecutableFlow flow;
        logger.info((Object)("Checking sla for execution " + this.execId));
        try {
            flow = this.executorLoader.fetchExecutableFlow(this.execId);
        }
        catch (ExecutorManagerException e) {
            logger.error((Object)"Can't get executable flow.", (Throwable)e);
            e.printStackTrace();
            return Boolean.TRUE;
        }
        return this.isSlaMissed(flow);
    }

    public Object isSlaFailed() {
        ExecutableFlow flow;
        try {
            flow = this.executorLoader.fetchExecutableFlow(this.execId);
        }
        catch (ExecutorManagerException e) {
            logger.error((Object)"Can't get executable flow.", (Throwable)e);
            return Boolean.TRUE;
        }
        return this.isSlaMissed(flow);
    }

    public Object isSlaPassed() {
        ExecutableFlow flow;
        try {
            flow = this.executorLoader.fetchExecutableFlow(this.execId);
        }
        catch (ExecutorManagerException e) {
            logger.error((Object)"Can't get executable flow.", (Throwable)e);
            return Boolean.TRUE;
        }
        return this.isSlaGood(flow);
    }

    @Override
    public Object getNum() {
        return null;
    }

    @Override
    public void reset() {
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getType() {
        return type;
    }

    @Override
    public ConditionChecker fromJson(Object obj) throws Exception {
        return SlaChecker.createFromJson(obj);
    }

    @Override
    public Object toJson() {
        HashMap<String, Object> jsonObj = new HashMap<String, Object>();
        jsonObj.put("type", type);
        jsonObj.put("id", this.id);
        jsonObj.put("slaOption", this.slaOption.toObject());
        jsonObj.put("execId", String.valueOf(this.execId));
        return jsonObj;
    }

    @Override
    public void stopChecker() {
    }

    @Override
    public void setContext(Map<String, Object> context) {
    }

    @Override
    public long getNextCheckTime() {
        return this.checkTime;
    }

    private boolean isFlowFinished(Status status) {
        if (status.equals((Object)Status.FAILED) || status.equals((Object)Status.KILLED) || status.equals((Object)Status.SUCCEEDED)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private boolean isFlowSucceeded(Status status) {
        return status.equals((Object)Status.SUCCEEDED);
    }

    private boolean isJobFinished(Status status) {
        if (status.equals((Object)Status.FAILED) || status.equals((Object)Status.KILLED) || status.equals((Object)Status.SUCCEEDED)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private boolean isJobSucceeded(Status status) {
        return status.equals((Object)Status.SUCCEEDED);
    }
}

