/*
 * Decompiled with CFR 0.152.
 */
package azkaban.project.validator;

import azkaban.project.validator.ValidatorManagerException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import java.util.jar.JarFile;
import sun.net.www.protocol.jar.JarURLConnection;

public class ValidatorClassLoader
extends URLClassLoader {
    protected HashSet<String> setJarFileNames2Close = new HashSet();

    public ValidatorClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public ValidatorClassLoader(URL[] urls) {
        super(urls);
    }

    @Override
    public void close() throws ValidatorManagerException {
        this.setJarFileNames2Close.clear();
        this.closeClassLoader(this);
        this.finalizeNativeLibs(this);
        this.cleanupJarFileFactory();
    }

    public boolean cleanupJarFileFactory() throws ValidatorManagerException {
        Object obj2;
        Field f;
        boolean res = false;
        Class<JarURLConnection> classJarURLConnection = JarURLConnection.class;
        try {
            f = classJarURLConnection.getDeclaredField("factory");
        }
        catch (NoSuchFieldException e) {
            throw new ValidatorManagerException(e);
        }
        if (f == null) {
            return false;
        }
        f.setAccessible(true);
        try {
            obj2 = f.get(null);
        }
        catch (IllegalAccessException e) {
            throw new ValidatorManagerException(e);
        }
        if (obj2 == null) {
            return false;
        }
        Class<?> classJarFileFactory = obj2.getClass();
        HashMap fileCache = null;
        try {
            f = classJarFileFactory.getDeclaredField("fileCache");
            f.setAccessible(true);
            obj2 = f.get(null);
            if (obj2 instanceof HashMap) {
                fileCache = (HashMap)obj2;
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ValidatorManagerException(e);
        }
        HashMap urlCache = null;
        try {
            f = classJarFileFactory.getDeclaredField("urlCache");
            f.setAccessible(true);
            obj2 = f.get(null);
            if (obj2 instanceof HashMap) {
                urlCache = (HashMap)obj2;
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new ValidatorManagerException(e);
        }
        if (urlCache != null) {
            HashMap urlCacheTmp = (HashMap)urlCache.clone();
            for (Object obj2 : urlCacheTmp.keySet()) {
                JarFile jarFile;
                if (!(obj2 instanceof JarFile) || !this.setJarFileNames2Close.contains((jarFile = (JarFile)obj2).getName())) continue;
                try {
                    jarFile.close();
                }
                catch (IOException e) {
                    throw new ValidatorManagerException(e);
                }
                if (fileCache != null) {
                    fileCache.remove(urlCache.get(jarFile));
                }
                urlCache.remove(jarFile);
            }
            res = true;
        } else if (fileCache != null) {
            HashMap fileCacheTmp = (HashMap)fileCache.clone();
            for (Object key : fileCacheTmp.keySet()) {
                JarFile jarFile;
                obj2 = fileCache.get(key);
                if (!(obj2 instanceof JarFile) || !this.setJarFileNames2Close.contains((jarFile = (JarFile)obj2).getName())) continue;
                try {
                    jarFile.close();
                }
                catch (IOException e) {
                    throw new ValidatorManagerException(e);
                }
                fileCache.remove(key);
            }
            res = true;
        }
        this.setJarFileNames2Close.clear();
        return res;
    }

    public boolean closeClassLoader(ClassLoader cl) throws ValidatorManagerException {
        boolean res = false;
        if (cl == null) {
            return res;
        }
        Class<URLClassLoader> classURLClassLoader = URLClassLoader.class;
        Field f = null;
        try {
            f = classURLClassLoader.getDeclaredField("ucp");
        }
        catch (NoSuchFieldException e) {
            throw new ValidatorManagerException(e);
        }
        if (f != null) {
            f.setAccessible(true);
            Object obj = null;
            try {
                obj = f.get(cl);
            }
            catch (IllegalAccessException e) {
                throw new ValidatorManagerException(e);
            }
            if (obj != null) {
                Object ucp = obj;
                f = null;
                try {
                    f = ucp.getClass().getDeclaredField("loaders");
                }
                catch (NoSuchFieldException e) {
                    throw new ValidatorManagerException(e);
                }
                if (f != null) {
                    f.setAccessible(true);
                    ArrayList loaders = null;
                    try {
                        loaders = (ArrayList)f.get(ucp);
                        res = true;
                    }
                    catch (IllegalAccessException e) {
                        throw new ValidatorManagerException(e);
                    }
                    for (int i = 0; loaders != null && i < loaders.size(); ++i) {
                        obj = loaders.get(i);
                        f = null;
                        try {
                            f = obj.getClass().getDeclaredField("jar");
                        }
                        catch (NoSuchFieldException e) {
                            throw new ValidatorManagerException(e);
                        }
                        if (f == null) continue;
                        f.setAccessible(true);
                        try {
                            obj = f.get(obj);
                        }
                        catch (IllegalAccessException e) {
                            throw new ValidatorManagerException(e);
                        }
                        if (!(obj instanceof JarFile)) continue;
                        JarFile jarFile = (JarFile)obj;
                        this.setJarFileNames2Close.add(jarFile.getName());
                        try {
                            jarFile.close();
                            continue;
                        }
                        catch (IOException e) {
                            throw new ValidatorManagerException(e);
                        }
                    }
                }
            }
        }
        return res;
    }

    public boolean finalizeNativeLibs(ClassLoader cl) throws ValidatorManagerException {
        boolean res = false;
        Class<ClassLoader> classClassLoader = ClassLoader.class;
        Field nativeLibraries = null;
        try {
            nativeLibraries = classClassLoader.getDeclaredField("nativeLibraries");
        }
        catch (NoSuchFieldException e) {
            throw new ValidatorManagerException(e);
        }
        if (nativeLibraries == null) {
            return res;
        }
        nativeLibraries.setAccessible(true);
        Object obj = null;
        try {
            obj = nativeLibraries.get(cl);
        }
        catch (IllegalAccessException e) {
            throw new ValidatorManagerException(e);
        }
        if (!(obj instanceof Vector)) {
            return res;
        }
        res = true;
        Vector java_lang_ClassLoader_NativeLibrary = (Vector)obj;
        for (Object lib : java_lang_ClassLoader_NativeLibrary) {
            Method finalize = null;
            try {
                finalize = lib.getClass().getDeclaredMethod("finalize", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new ValidatorManagerException(e);
            }
            if (finalize == null) continue;
            finalize.setAccessible(true);
            try {
                finalize.invoke(lib, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new ValidatorManagerException(e);
            }
            catch (InvocationTargetException e) {
                throw new ValidatorManagerException(e);
            }
        }
        return res;
    }
}

